#ifndef DRIVETRAIN_H
#define DRIVETRAIN_H
#include "Commands/Subsystem.h"
#include "WPILib.h"
#include "../XboxController.h"

/**
 *
 *
 * @author LAPSTATION0
 */
class DriveTrain: public Subsystem 
{
private:
	// It's desirable that everything possible under private except
	// for methods that implement subsystem capabilities
	DoubleSolenoid * m_shifters;
	Talon * m_motorLeft,
		  * m_motorRight;
	RobotDrive * m_drive;
	Gyro * m_gyro;
	Encoder * m_leftEncoder;

	
public:
	DriveTrain();
	void InitDefaultCommand();
	void DriveArcade(Joystick * stick);
	void DriveArcadeAuto(float speed, float rotation);
	void DriveTankDrive(float leftValue, float rightValue);
	void DriveXbox(XboxController * xbox);
	void XboxPaulDrive(XboxController * xbox);
	void XboxTankDrive(XboxController * xbox);
	void ShiftHi();
	void ShiftLo();
	float GetGyroAngle();
	void GyroReset();
	int32_t GetEncoder();
	void StartEncoder();
	void StopEncoder();
	void ResetEncoder();
	double GetDistance();
	bool GetDirection();
	double GetRate();
	bool GetStopped();
	
};

#endif
