#ifndef ROBOTMAP_H
#define ROBOTMAP_H


/**
 * The RobotMap is a mapping from the ports sensors and actuators are wired into
 * to a variable name. This provides flexibility changing wiring, makes checking
 * the wiring easier and significantly reduces the number of magic numbers
 * floating around.
 */

/*
EXAMPLE ORGANIZATION
 
Subsystem1
	Motor Controllers
 		#define motorc1
 		#define motorc2
 	Relays
 		#define relay1
 	 	#define relay2
 	Analog
 		#define analog1
 		#define analog2
	Digital
		#define digital1
		#define digital2
	OI
		#define OI1
 		#define OI2
 	Other 
		#define other1
 		#define other2
  
 Subsystem2
 		etc.....
 */
 
//DriveTrain
	//Wheel Geometry
		#define WHEEL_DIAMETER 4
		#define ENCODER_RESOLUTION 250
		#define PI 3.1415926
		#define MIN_RATE 0.1
		#define SAMPLES_AVG 7
	//Motor controllers
		#define DRIVE_MOTOR_LEFT  1
		#define DRIVE_MOTOR_RIGHT 2
	//Relays
		#define DRIVE_SOLENOID_SHIFT_HI 2
		#define DRIVE_SOLENOID_SHIFT_LO 3
	//Analog
		#define DRIVE_GYRO 2
	//Digital
		#define DRIVE_LEFT_ENCODER_A 3
		#define DRIVE_LEFT_ENCODER_B 4
		#define DRIVE_RIGHT_ENCODER_A 1
		#define DRIVE_RIGHT_ENCODER_B 2
	// OI
		#define JOYSTICK_1 1
		#define XBOX_1 3
		#define XBOX_DEFECATE 9
		#define BUTTON_SHIFT 1

// Compressor
	//Relays
		#define COMPRESSOR_RELAY 1
	//Digital
		#define COMPRESSOR_PRESSURE_SWITCH 1
#endif
