#include "OI.h"
#include "Robotmap.h"
#include "Commands/DriveTrain/ShiftLo.h"
#include "Commands/DriveTrain/ShiftHi.h"
#include "BroncoJoy.h"
#include "XboxController.h"

OI::OI() {
	// Process operator interface input here.
	stick1 = new BroncoJoy(JOYSTICK_1);
	xbox = new XboxController(XBOX_1);
	
	shift = new JoystickButton(stick1, BUTTON_SHIFT);
	shiftXbox = new JoystickButton(xbox, XBOX_DEFECATE);
	shift->WhenPressed(new ShiftLo());
	shift->WhenReleased(new ShiftHi());
	shiftXbox->WhenPressed(new ShiftLo());
	shiftXbox->WhenReleased(new ShiftHi());
}

Joystick *OI::getStick()
{
	return stick1;
}

XboxController *OI::getXbox()
{
	return xbox;
}
