/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Solenoid;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.templates.RobotMap;

/**
 *
 * @author team1987
 */
public class BridgeArm extends Subsystem {
    // Put methods for controlling this subsystem
    // here. Call these from Commands.
    Solenoid m_arm1 = new Solenoid(RobotMap.BRIDGE_ARM_PORT1);
    Solenoid m_arm2 = new Solenoid(RobotMap.BRIDGE_ARM_PORT2);
    DigitalInput m_armUpSwitch = new DigitalInput(RobotMap.BRIDGE_UP_SWITCH);
    DigitalInput m_armDownSwitch = new DigitalInput(RobotMap.BRIDGE_DOWN_SWITCH);
    private boolean changed = false;

    public void initDefaultCommand() {
        // Set the default command for a subsystem here.
        //setDefaultCommand(new H_BridgeArm_ChangePosition());
    }
    
    public void armDown() {
        m_arm1.set(false);
        m_arm2.set(true);
        changed = true;
    }
    
    public void armUp() {
        m_arm1.set(true);
        m_arm2.set(false);
        changed = true;
    }
    
    public void armToggle() {
        changed = false;
        if((m_arm1.get() == false)) {
            m_arm1.set(true);
            m_arm2.set(false);
            changed = true;
        }
        else if ((m_arm1.get() == true)) {
            m_arm1.set(false);
            m_arm2.set(true);
            changed = true;
        }
    }
    
    public boolean getSolenoid() {
        return m_arm1.get();
    }
    
    public boolean positionChanged() {
        return changed;
    }
}
