/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.Jaguar;
import edu.wpi.first.wpilibj.PIDController;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;

public class Turret
extends Subsystem {
    protected AnalogChannel m_POT = new AnalogChannel(1, 3);
    protected SpeedController m_TMOTOR = new Jaguar(7);
    protected static int MAX_RIGHT = 860;
    protected static int MAX_LEFT = 60;
    protected PIDController m_turretPID = new PIDController(-0.01, -0.001, 0.0, this.m_POT, this.m_TMOTOR, 0.05);

    public Turret() {
        this.m_turretPID.setInputRange(100.0, 800.0);
        this.m_turretPID.setOutputRange(-0.5, 0.5);
    }

    public void initDefaultCommand() {
    }

    public void setTurretPosition(double setPoint) {
        this.m_turretPID.setSetpoint(setPoint);
    }

    public void setPID(boolean status) {
        if (status) {
            this.m_turretPID.enable();
        } else {
            this.m_turretPID.disable();
        }
    }

    public int getTurretPosition() {
        return this.m_POT.getValue();
    }

    public boolean isTargeted() {
        return this.m_turretPID.onTarget();
    }

    public void moveTurret(double speed) {
        this.m_turretPID.disable();
        if (this.m_POT.getValue() <= MAX_RIGHT && this.m_POT.getValue() >= MAX_LEFT) {
            this.m_TMOTOR.set(speed);
            System.out.println("Moving NORMAL; POT: " + this.m_POT.getValue());
        } else if (this.m_POT.getValue() >= MAX_RIGHT && speed < 0.0) {
            this.m_TMOTOR.set(speed);
            System.out.println("Moving LEFT; POT: " + this.m_POT.getValue());
        } else if (this.m_POT.getValue() <= MAX_LEFT && speed > 0.0) {
            System.out.println("Moving RIGHT; POT: " + this.m_POT.getValue());
            this.m_TMOTOR.set(speed);
        } else {
            this.m_TMOTOR.set(0.0);
        }
    }

    public void print() {
        SmartDashboard.putInt("POT:", this.getTurretPosition());
        SmartDashboard.putDouble("Target:", this.m_turretPID.getSetpoint());
    }
}

