/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.camera.AxisCamera;
import edu.wpi.first.wpilibj.camera.AxisCameraException;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.image.BinaryImage;
import edu.wpi.first.wpilibj.image.ColorImage;
import edu.wpi.first.wpilibj.image.CriteriaCollection;
import edu.wpi.first.wpilibj.image.NIVision;
import edu.wpi.first.wpilibj.image.NIVisionException;
import edu.wpi.first.wpilibj.image.ParticleAnalysisReport;
import edu.wpi.first.wpilibj.templates.commands.lowlevel.L_Targeting_Target;

public class Targeting
extends Subsystem {
    AxisCamera camera = AxisCamera.getInstance();
    CriteriaCollection cc = new CriteriaCollection();

    public void initDefaultCommand() {
        this.setDefaultCommand(new L_Targeting_Target());
    }

    public Targeting() {
        this.cc.addCriteria(NIVision.MeasurementType.IMAQ_MT_BOUNDING_RECT_WIDTH, 30.0f, 400.0f, false);
        this.cc.addCriteria(NIVision.MeasurementType.IMAQ_MT_BOUNDING_RECT_HEIGHT, 40.0f, 400.0f, false);
    }

    public void target() {
        System.out.println("+++++++++++++TARGETING+++++++++++++");
        double bestTgtX = 0.0;
        double bestTgtY = -1.0;
        try {
            ColorImage image = null;
            try {
                image = this.camera.getImage();
            }
            catch (AxisCameraException ex) {
                ex.printStackTrace();
            }
            catch (NIVisionException ex) {
                ex.printStackTrace();
            }
            BinaryImage thresholdImage = image.thresholdRGB(65, 160, 225, 255, 250, 255);
            BinaryImage bigObjectsImage = thresholdImage.removeSmallObjects(false, 2);
            BinaryImage convexHullImage = bigObjectsImage.convexHull(false);
            BinaryImage filteredImage = convexHullImage.particleFilter(this.cc);
            ParticleAnalysisReport[] reports = filteredImage.getOrderedParticleAnalysisReports();
            for (int i = 0; i < reports.length; ++i) {
                ParticleAnalysisReport r = reports[i];
                if (!(r.center_mass_y_normalized > bestTgtY)) continue;
                System.out.println("Rectangle Width " + r.boundingRectWidth);
                bestTgtY = r.center_mass_y_normalized;
                bestTgtX = r.center_mass_x_normalized;
            }
            System.out.println(filteredImage.getNumberParticles() + "  " + Timer.getFPGATimestamp());
            filteredImage.free();
            convexHullImage.free();
            bigObjectsImage.free();
            thresholdImage.free();
            image.free();
        }
        catch (NIVisionException ex) {
            ex.printStackTrace();
        }
    }
}

