/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.subsystems;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.Jaguar;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.PIDController;
import edu.wpi.first.wpilibj.SpeedController;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.templates.commands.highlevel.H_ShooterMain;

public class Shooter
extends Subsystem {
    protected AnalogChannel m_shooterPOT;
    protected PIDController m_shooterPID;
    protected DigitalInput m_motorSensor;
    protected AnalogChannel m_rangeFinder;
    protected SpeedController m_angleMotor;
    protected SpeedController m_topMotor = new Jaguar(3);
    protected SpeedController m_bottomMotor = new Jaguar(4);
    private int throttleAngle;
    private int angleInPOT;
    private int angleInDegrees;

    public void initDefaultCommand() {
        this.setDefaultCommand(new H_ShooterMain());
    }

    public Shooter() {
        this.m_angleMotor = new Jaguar(6);
        this.m_shooterPOT = new AnalogChannel(1, 1);
        this.m_motorSensor = new DigitalInput(12);
        this.m_rangeFinder = new AnalogChannel(1, 2);
        this.m_shooterPID = new PIDController(-0.025, -1.0E-4, 0.0, this.m_shooterPOT, this.m_angleMotor, 0.05);
        this.m_shooterPID.setInputRange(50.0, 220.0);
        this.m_shooterPID.setOutputRange(-0.6, 0.6);
    }

    public void runShooter(double speedTOP, double speedBOT, double bottomTopRatio) {
        this.m_topMotor.set(speedTOP * bottomTopRatio);
        this.m_bottomMotor.set(speedBOT);
    }

    public void runShooter(double speedTOP, double speedBOT) {
        this.m_topMotor.set(speedTOP);
        this.m_bottomMotor.set(speedBOT);
    }

    public void runShooter(Joystick stick) {
        double speed = -1.0 * (stick.getThrottle() - 1.0) / -2.0;
        this.m_topMotor.set(speed * 0.75);
        this.m_bottomMotor.set(speed);
    }

    public double getShooterSpeed() {
        return this.m_topMotor.get();
    }

    public void updateStatus() {
    }

    public void setAngle(double angle) {
        if (angle < 130.0 && angle > 0.0) {
            this.angleInPOT = (int)(170.0 * (angle / 130.0) + 50.0);
            this.m_shooterPID.setSetpoint(this.angleInPOT);
        } else {
            this.m_angleMotor.set(0.0);
        }
    }

    public double getAngle() {
        this.angleInDegrees = 130 * (this.m_shooterPOT.getAverageValue() - 50) / 170;
        return this.angleInDegrees;
    }

    public double getTargetAngle() {
        return this.throttleAngle;
    }

    public double getRawPOTValue() {
        return this.m_shooterPOT.getValue();
    }

    public void setPID(boolean value) {
        if (value) {
            this.m_shooterPID.enable();
        } else {
            this.m_shooterPID.disable();
        }
    }

    public boolean getPID() {
        return this.m_shooterPID.isEnable();
    }

    public double getSP() {
        return this.m_shooterPID.getSetpoint();
    }

    public void throttleToShooter(Joystick stick) {
        this.throttleAngle = (int)(130.0 * (stick.getThrottle() - 1.0) / -2.0);
        this.setAngle(this.throttleAngle);
    }

    public double getRawUltrasonic() {
        return this.m_rangeFinder.getAverageVoltage();
    }

    public void setTrajectory(double angle, double speed, double bottomTopRatio) {
        this.setAngle(angle);
        this.runShooter(speed, speed, bottomTopRatio);
    }

    public void setTrajectory(double angle, double speed) {
        this.setAngle(angle);
        this.runShooter(speed, speed);
    }
}

