/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates.commands.highlevel;

import edu.wpi.first.wpilibj.templates.RobotMap;
import edu.wpi.first.wpilibj.templates.commands.CommandBase;

public class H_ShooterPreset
extends CommandBase {
    private double m_angle;
    private double m_speed;
    private double m_ratio;
    private double m_timeout;

    public H_ShooterPreset(double speed, double angle, double bottomTopRatio, int timeout) {
        this.requires(shooter);
        this.m_angle = angle;
        this.m_speed = speed;
        this.m_ratio = bottomTopRatio;
        this.m_timeout = timeout;
    }

    protected void initialize() {
        this.setTimeout(this.m_timeout);
        shooter.setPID(true);
    }

    protected void execute() {
        shooter.setTrajectory(this.m_angle, this.m_speed);
    }

    protected boolean isFinished() {
        if (RobotMap.isAutonomous) {
            return this.isTimedOut();
        }
        if (RobotMap.S2bttn11Pressed) {
            return !RobotMap.S2bttn11Pressed;
        }
        if (RobotMap.S2bttn2Pressed) {
            return !RobotMap.S2bttn2Pressed;
        }
        return false;
    }

    protected void end() {
        if (RobotMap.isAutonomous) {
            shooter.setPID(true);
        } else if (RobotMap.isTeleop) {
            shooter.setPID(false);
        }
    }

    protected void interrupted() {
    }
}

