/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.templates;

import edu.wpi.first.wpilibj.Compressor;
import edu.wpi.first.wpilibj.IterativeRobot;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.Scheduler;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboard;
import edu.wpi.first.wpilibj.templates.RobotMap;
import edu.wpi.first.wpilibj.templates.commands.CommandBase;
import edu.wpi.first.wpilibj.templates.commands.highlevel.H_MiddleAuto;
import edu.wpi.first.wpilibj.templates.commands.highlevel.H_ShooterMain;
import edu.wpi.first.wpilibj.templates.commands.lowlevel.L_Elevator_GetBallCount;

public class RobotTemplate
extends IterativeRobot {
    Command autonomousCommand;
    Command printTurretPOT;
    Command printShooterData;
    Command printBallCount;
    Compressor compressor;

    public void robotInit() {
        this.autonomousCommand = new H_MiddleAuto();
        this.printShooterData = new H_ShooterMain();
        this.printBallCount = new L_Elevator_GetBallCount();
        this.compressor = new Compressor(1, 1);
        SmartDashboard.putData(Scheduler.getInstance());
        CommandBase.init();
    }

    public void autonomousInit() {
        this.printBallCount.start();
        this.compressor.start();
        RobotMap.isAutonomous = true;
        RobotMap.isTeleop = false;
        RobotMap.autoStarted = false;
    }

    public void autonomousPeriodic() {
        if (!this.autonomousCommand.isRunning() && !RobotMap.autoStarted) {
            RobotMap.numBalls = 0;
            this.autonomousCommand.start();
            RobotMap.autoStarted = true;
        }
        Scheduler.getInstance().run();
    }

    public void teleopInit() {
        this.autonomousCommand.cancel();
        this.printShooterData.cancel();
        this.printBallCount.cancel();
        this.compressor.start();
        RobotMap.isAutonomous = false;
        RobotMap.isTeleop = true;
    }

    public void teleopPeriodic() {
        this.compressor.start();
        Scheduler.getInstance().run();
        this.printShooterData.start();
        this.printBallCount.start();
        SmartDashboard.putBoolean("Shifters", CommandBase.chassis.getShifters());
        SmartDashboard.putBoolean("Arm", CommandBase.bridgeArm.getSolenoid());
    }

    public void updateStatus() {
    }
}

