/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.smartdashboard;

import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.networktables.NetworkTableKeyNotDefined;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboardData;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboardNamedData;
import java.util.Hashtable;

public class SmartDashboard {
    private static final NetworkTable table = NetworkTable.getTable("SmartDashboard");
    private static final Hashtable tablesToData = new Hashtable();

    public static void putData(String key, SmartDashboardData value) {
        NetworkTable type = new NetworkTable();
        type.putString("~TYPE~", value.getType());
        type.putSubTable("Data", value.getTable());
        table.putSubTable(key, type);
        tablesToData.put(type, key);
    }

    public static void putData(SmartDashboardNamedData value) {
        SmartDashboard.putData(value.getName(), value);
    }

    public static SmartDashboardData getData(String key) throws NetworkTableKeyNotDefined {
        NetworkTable subtable = table.getSubTable(key);
        Object data = tablesToData.get(subtable);
        if (data == null) {
            throw new IllegalArgumentException("Value at \"" + key + "\" is not a boolean");
        }
        return (SmartDashboardData)data;
    }

    public static void putBoolean(String key, boolean value) {
        table.putBoolean(key, value);
    }

    public static boolean getBoolean(String key) throws NetworkTableKeyNotDefined {
        return table.getBoolean(key);
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        try {
            return table.getBoolean(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public static void putInt(String key, int value) {
        table.putInt(key, value);
    }

    public static int getInt(String key) throws NetworkTableKeyNotDefined {
        return table.getInt(key);
    }

    public static int getInt(String key, int defaultValue) {
        try {
            return table.getInt(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public static void putDouble(String key, double value) {
        table.putDouble(key, value);
    }

    public static double getDouble(String key) throws NetworkTableKeyNotDefined {
        return table.getDouble(key);
    }

    public static double getDouble(String key, double defaultValue) {
        try {
            return table.getDouble(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public static void putString(String key, String value) {
        table.putString(key, value);
    }

    public static String getString(String key) throws NetworkTableKeyNotDefined {
        return table.getString(key);
    }

    public static String getString(String key, String defaultValue) {
        try {
            return table.getString(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public static void init() {
    }

    public static int log(byte value, String name) {
        SmartDashboard.putInt(name, value);
        return 0;
    }

    public static int log(char value, String name) {
        SmartDashboard.putInt(name, value);
        return 0;
    }

    public static int log(int value, String name) {
        SmartDashboard.putInt(name, value);
        return 0;
    }

    public static int log(long value, String name) {
        SmartDashboard.putInt(name, (int)value);
        return 0;
    }

    public static int log(short value, String name) {
        SmartDashboard.putInt(name, value);
        return 0;
    }

    public static int log(float value, String name) {
        SmartDashboard.putDouble(name, value);
        return 0;
    }

    public static int log(double value, String name) {
        SmartDashboard.putDouble(name, value);
        return 0;
    }

    public static int log(String value, String name) {
        SmartDashboard.putString(name, value);
        return 0;
    }

    public static int log(boolean value, String name) {
        SmartDashboard.putBoolean(name, value);
        return 0;
    }

    public static int useProfile(String name) {
        return 0;
    }

    public static String diagnoseErrorCode(int code) {
        return "diagnoseErrorCode(int code) is deprecated";
    }

    public static void useBlockingIO(boolean value) {
    }
}

