/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.Buffer;
import edu.wpi.first.wpilibj.networktables.Connection;
import edu.wpi.first.wpilibj.networktables.ConnectionManager;
import edu.wpi.first.wpilibj.networktables.Entry;
import edu.wpi.first.wpilibj.networktables.Key;
import edu.wpi.first.wpilibj.networktables.NetworkAdditionListener;
import edu.wpi.first.wpilibj.networktables.NetworkConnectionListener;
import edu.wpi.first.wpilibj.networktables.NetworkListener;
import edu.wpi.first.wpilibj.networktables.NetworkQueue;
import edu.wpi.first.wpilibj.networktables.NetworkTableKeyNotDefined;
import edu.wpi.first.wpilibj.networktables.Set;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class NetworkTable {
    private static Hashtable tables;
    private static int currentId;
    private static Hashtable ids;
    private Set connections;
    private Set listenToAllListeners;
    private Hashtable listeners;
    private Set additionListeners;
    private Set connectionListeners;
    private final Object listenerLock = new Object();
    private Hashtable data = new Hashtable();
    private final Integer id = this.grabId();
    private NetworkQueue transaction = new NetworkQueue();
    private int transactionCount = 0;
    private NetworkQueue hasChanged = new NetworkQueue();
    private NetworkQueue hasAdded = new NetworkQueue();

    public static synchronized void initialize() {
        if (tables == null) {
            tables = new Hashtable();
            ConnectionManager.getInstance();
        }
    }

    public static synchronized NetworkTable getTable(String name) {
        NetworkTable.initialize();
        if (tables.containsKey(name)) {
            return (NetworkTable)tables.get(name);
        }
        NetworkTable table = new NetworkTable();
        tables.put(name, table);
        return table;
    }

    static NetworkTable getTable(Integer id) {
        return (NetworkTable)ids.get(id);
    }

    private synchronized Integer grabId() {
        return new Integer(currentId++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTransaction() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.transactionCount == 0) {
                throw new RuntimeException("End transaction called too many times...");
            }
            if (--this.transactionCount == 0) {
                this.processTransaction(true, this.transaction);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processTransaction(boolean confirmed, NetworkQueue transaction) {
        if (transaction.isEmpty()) {
            return;
        }
        Connection source = ((Entry)transaction.peek()).getSource();
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.isConnected()) {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection connection = (Connection)this.connections.get(i);
                    if (connection == source) continue;
                    connection.offerTransaction(transaction);
                }
            }
            while (!transaction.isEmpty()) {
                Entry entry = (Entry)transaction.poll();
                Entry oldEntry = entry.getKey().setEntry(entry);
                if (oldEntry == null) {
                    this.hasAdded.offer(entry);
                    continue;
                }
                if (entry.equals(oldEntry)) continue;
                this.hasChanged.offer(entry);
            }
            while (!this.hasAdded.isEmpty()) {
                Entry entry = (Entry)this.hasAdded.poll();
                this.alertListeners(true, confirmed, entry.getKey().getName(), entry);
            }
            while (!this.hasChanged.isEmpty()) {
                Entry entry = (Entry)this.hasChanged.poll();
                this.alertListeners(true, confirmed, entry.getKey().getName(), entry);
            }
        }
    }

    Integer getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addConnection(Connection connection) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.connections == null) {
                this.connections = new Set();
            }
            if (this.connections.add(connection)) {
                Enumeration keys = this.data.elements();
                while (keys.hasMoreElements()) {
                    Key key = (Key)keys.nextElement();
                    connection.offer(key);
                    if (!key.hasEntry()) continue;
                    connection.offer(key.getEntry());
                }
                if (this.connections.size() == 1) {
                    ids.put(this.id, this);
                    if (this.connectionListeners != null) {
                        for (int i = 0; i < this.connectionListeners.size(); ++i) {
                            ((NetworkConnectionListener)this.connectionListeners.get(i)).connected();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(Connection connection) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            this.connections.remove(connection);
            if (this.connections.size() == 0) {
                ids.remove(this.id);
                if (this.connectionListeners != null) {
                    for (int i = 0; i < this.connectionListeners.size(); ++i) {
                        ((NetworkConnectionListener)this.connectionListeners.get(i)).disconnected();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getKeys() {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Enumeration elements = this.data.elements();
            Vector<String> result = new Vector<String>();
            while (elements.hasMoreElements()) {
                Key key = (Key)elements.nextElement();
                if (!key.hasEntry()) continue;
                result.addElement(key.getName());
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Key getKey(String name) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key key = (Key)this.data.get(name);
            if (key == null) {
                key = new Key(this, name);
                this.data.put(name, key);
                if (this.connections != null) {
                    for (int i = 0; i < this.connections.size(); ++i) {
                        ((Connection)this.connections.get(i)).offer(key);
                    }
                }
            }
            return key;
        }
    }

    public void putInt(String key, int value) {
        this.put(key, new Entry.IntegerEntry(value));
    }

    public void putBoolean(String key, boolean value) {
        this.put(key, new Entry.BooleanEntry(value));
    }

    public void putDouble(String key, double value) {
        this.put(key, new Entry.DoubleEntry(value));
    }

    public void putString(String key, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Given null value");
        }
        this.put(key, new Entry.StringEntry(value));
    }

    public void putSubTable(String key, NetworkTable value) {
        if (value == null) {
            throw new IllegalArgumentException("Given null value");
        }
        this.put(key, new Entry.TableEntry(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String field, Entry value) {
        if (field == null) {
            throw new IllegalArgumentException("Given null key");
        }
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key key = this.getKey(field);
            value.setKey(key);
            if (this.transactionCount == 0) {
                this.got(true, key, value);
            } else {
                this.transaction.offer(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void send(Entry entry) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            if (this.isConnected()) {
                for (int i = 0; i < this.connections.size(); ++i) {
                    Connection connection = (Connection)this.connections.get(i);
                    if (connection == entry.getSource()) continue;
                    connection.offer(entry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(String key, NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set list;
            if (this.listeners == null) {
                this.listeners = new Hashtable();
            }
            if ((list = (Set)this.listeners.get(key)) == null) {
                list = new Set();
                this.listeners.put(key, list);
            }
            list.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListenerToAll(NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listenToAllListeners == null) {
                this.listenToAllListeners = new Set();
            }
            this.listenToAllListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(String key, NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            Set list;
            if (this.listeners != null && (list = (Set)this.listeners.get(key)) != null) {
                list.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListenerFromAll(NetworkListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.listenToAllListeners != null) {
                this.listenToAllListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAdditionListener(NetworkAdditionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.additionListeners == null) {
                this.additionListeners = new Set();
            }
            this.additionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAdditionListener(NetworkAdditionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.additionListeners != null) {
                this.additionListeners.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(NetworkConnectionListener listener, boolean immediateNotify) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.connectionListeners == null) {
                this.connectionListeners = new Set();
            }
            this.connectionListeners.add(listener);
            if (immediateNotify) {
                if (this.isConnected()) {
                    listener.connected();
                } else {
                    listener.disconnected();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(NetworkConnectionListener listener) {
        Object object = this.listenerLock;
        synchronized (object) {
            if (this.connectionListeners != null) {
                this.connectionListeners.remove(listener);
            }
        }
    }

    public Object getValue(String key) throws NetworkTableKeyNotDefined {
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        return entry.getValue();
    }

    public int getInt(String key) throws NetworkTableKeyNotDefined {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        if (entry instanceof Entry.IntegerEntry) {
            return entry.getInt();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not an int");
    }

    public double getDouble(String key) throws NetworkTableKeyNotDefined {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        if (entry instanceof Entry.DoubleEntry) {
            return entry.getDouble();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a double");
    }

    public String getString(String key) throws NetworkTableKeyNotDefined {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        if (entry instanceof Entry.StringEntry) {
            return entry.getString();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a string");
    }

    public NetworkTable getSubTable(String key) throws NetworkTableKeyNotDefined {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        if (entry instanceof Entry.TableEntry) {
            return entry.getTable();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a table");
    }

    public boolean getBoolean(String key) throws NetworkTableKeyNotDefined {
        if (key == null) {
            throw new IllegalArgumentException("given null key");
        }
        Entry entry = this.getEntry(key);
        if (entry == null) {
            throw new NetworkTableKeyNotDefined();
        }
        if (entry instanceof Entry.BooleanEntry) {
            return entry.getBoolean();
        }
        throw new IllegalArgumentException("Value at \"" + key + "\" is not a boolean");
    }

    public int getInt(String key, int defaultValue) {
        try {
            return this.getInt(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public double getDouble(String key, double defaultValue) {
        try {
            return this.getDouble(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public String getString(String key, String defaultValue) {
        try {
            return this.getString(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return this.getBoolean(key);
        }
        catch (NetworkTableKeyNotDefined ex) {
            return defaultValue;
        }
    }

    public boolean isConnected() {
        return this.connections != null && this.connections.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key k = (Key)this.data.get(key);
            return k != null && k.hasEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Entry getEntry(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Can not be given null");
        }
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            Key k = (Key)this.data.get(key);
            return k == null ? null : k.getEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void got(boolean confirmed, Key key, Entry value) {
        Entry old;
        NetworkTable networkTable = this;
        synchronized (networkTable) {
            old = key.setEntry(value);
        }
        if (value.equals(old)) {
            return;
        }
        this.send(value);
        this.alertListeners(old == null, confirmed, key.getName(), value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void alertListeners(boolean isNew, boolean confirmed, String key, Entry value) {
        Object object = this.listenerLock;
        synchronized (object) {
            NetworkListener listener;
            int i;
            if (isNew && this.additionListeners != null) {
                for (int i2 = 0; i2 < this.additionListeners.size(); ++i2) {
                    ((NetworkAdditionListener)this.additionListeners.get(i2)).fieldAdded(key, value.getValue());
                }
            }
            Set list = null;
            if (this.listeners != null) {
                list = (Set)this.listeners.get(key);
            }
            if (list != null) {
                for (i = 0; i < list.size(); ++i) {
                    listener = (NetworkListener)list.get(i);
                    if (confirmed) {
                        listener.valueConfirmed(key, value.getValue());
                        continue;
                    }
                    listener.valueChanged(key, value.getValue());
                }
            }
            if ((list = this.listenToAllListeners) != null) {
                for (i = 0; i < list.size(); ++i) {
                    listener = (NetworkListener)list.get(i);
                    if (confirmed) {
                        listener.valueConfirmed(key, value.getValue());
                        continue;
                    }
                    listener.valueChanged(key, value.getValue());
                }
            }
        }
    }

    void encodeName(Buffer buffer) {
        buffer.writeTableId(this.id);
    }

    static {
        currentId = 1;
        ids = new Hashtable();
    }
}

