/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.Buffer;
import edu.wpi.first.wpilibj.networktables.Connection;
import edu.wpi.first.wpilibj.networktables.Data;
import edu.wpi.first.wpilibj.networktables.Key;
import edu.wpi.first.wpilibj.networktables.NetworkTable;

abstract class Entry
implements Data {
    private Key key;
    private Connection source;
    private Object value;

    Entry() {
    }

    void setKey(Key key) {
        this.key = key;
    }

    Key getKey() {
        return this.key;
    }

    abstract int getType();

    void setSource(Connection source) {
        this.source = source;
    }

    Connection getSource() {
        return this.source;
    }

    abstract Object grabValue();

    public Object getValue() {
        return this.value == null ? (this.value = this.grabValue()) : this.value;
    }

    public void encode(Buffer buffer) {
        this.getKey().encodeName(buffer);
    }

    int getInt() {
        throw new UnsupportedOperationException();
    }

    double getDouble() {
        throw new UnsupportedOperationException();
    }

    boolean getBoolean() {
        throw new UnsupportedOperationException();
    }

    String getString() {
        throw new UnsupportedOperationException();
    }

    NetworkTable getTable() {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object obj) {
        return obj instanceof Entry && this.grabValue().equals(((Entry)obj).grabValue());
    }

    public int hashCode() {
        return this.grabValue().hashCode();
    }

    public static class UnsupportedOperationException
    extends RuntimeException {
    }

    static class TableEntry
    extends Entry {
        private NetworkTable value;

        public TableEntry(NetworkTable value) {
            this.value = value;
        }

        Object grabValue() {
            return this.value;
        }

        NetworkTable getTable() {
            return this.value;
        }

        int getType() {
            return 3;
        }

        public void encode(Buffer buffer) {
            super.encode(buffer);
            this.value.encodeName(buffer);
        }

        public String toString() {
            return "[Table]";
        }
    }

    static class StringEntry
    extends Entry {
        private String value;

        public StringEntry(String value) {
            this.value = value;
        }

        Object grabValue() {
            return this.value;
        }

        String getString() {
            return this.value;
        }

        int getType() {
            return 0;
        }

        public void encode(Buffer buffer) {
            super.encode(buffer);
            buffer.writeByte(0);
            buffer.writeString(this.value);
        }

        public String toString() {
            return "[String:" + this.value + "]";
        }
    }

    static class BooleanEntry
    extends Entry {
        private boolean value;

        public BooleanEntry(boolean value) {
            this.value = value;
        }

        Object grabValue() {
            return this.value ? Boolean.TRUE : Boolean.FALSE;
        }

        boolean getBoolean() {
            return this.value;
        }

        int getType() {
            return 5;
        }

        public void encode(Buffer buffer) {
            super.encode(buffer);
            buffer.writeByte(this.value ? 5 : 4);
        }

        public String toString() {
            return "[boolean:" + this.value + "]";
        }
    }

    static class IntegerEntry
    extends Entry {
        private int value;

        public IntegerEntry(int value) {
            this.value = value;
        }

        Object grabValue() {
            return new Integer(this.value);
        }

        int getInt() {
            return this.value;
        }

        int getType() {
            return 1;
        }

        public void encode(Buffer buffer) {
            super.encode(buffer);
            buffer.writeByte(1);
            buffer.writeInt(this.value);
        }

        public String toString() {
            return "[int:" + this.value + "]";
        }
    }

    static class DoubleEntry
    extends Entry {
        private double value;

        public DoubleEntry(double value) {
            this.value = value;
        }

        Object grabValue() {
            return new Double(this.value);
        }

        double getDouble() {
            return this.value;
        }

        int getType() {
            return 2;
        }

        public void encode(Buffer buffer) {
            super.encode(buffer);
            buffer.writeByte(2);
            buffer.writeDouble(this.value);
        }

        public String toString() {
            return "[Double:" + this.value + "]";
        }
    }
}

