/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.Connection;
import edu.wpi.first.wpilibj.networktables.Set;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.ServerSocketConnection;
import javax.microedition.io.SocketConnection;

class ConnectionManager {
    private static ConnectionManager m_instance;
    final boolean IS_SERVER;
    private final int PORT;
    private Set connections = new Set();

    public static synchronized ConnectionManager getInstance() {
        if (m_instance == null) {
            m_instance = new ConnectionManager();
        }
        return m_instance;
    }

    private ConnectionManager() {
        this.IS_SERVER = true;
        this.PORT = 1735;
        new Thread(){

            public void run() {
                ConnectionManager.this.acceptConnections();
            }
        }.start();
    }

    private void acceptConnections() {
        ServerSocketConnection server = null;
        while (true) {
            try {
                server = (ServerSocketConnection)Connector.open((String)"socket://:1735");
            }
            catch (IOException ex) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        try {
            while (true) {
                SocketConnection socket = (SocketConnection)server.acceptAndOpen();
                socket.setSocketOption((byte)1, 0);
                this.addConnection(new Connection(socket));
            }
        }
        catch (IOException ex) {
            System.out.println("NetworkingTable: LOST SERVER!");
            return;
        }
    }

    private synchronized void addConnection(Connection connection) {
        if (!this.connections.add(connection)) {
            System.err.println("ResourceAlreadyAllocated: Connection object already exists");
            return;
        }
        connection.start();
    }

    synchronized void removeConnection(Connection connection) {
        this.connections.remove(connection);
    }
}

