/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import edu.wpi.first.wpilibj.networktables.Buffer;
import edu.wpi.first.wpilibj.networktables.Confirmation;
import edu.wpi.first.wpilibj.networktables.ConnectionManager;
import edu.wpi.first.wpilibj.networktables.CountingQueue;
import edu.wpi.first.wpilibj.networktables.Data;
import edu.wpi.first.wpilibj.networktables.Denial;
import edu.wpi.first.wpilibj.networktables.Entry;
import edu.wpi.first.wpilibj.networktables.Key;
import edu.wpi.first.wpilibj.networktables.LinkedList;
import edu.wpi.first.wpilibj.networktables.NetworkQueue;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.networktables.OldData;
import edu.wpi.first.wpilibj.networktables.Reader;
import edu.wpi.first.wpilibj.networktables.TableAssignment;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.SocketConnection;

class Connection {
    private static final long WRITE_DELAY = 250L;
    private static final long TIMEOUT = 1000L;
    private final SocketConnection socket;
    private final Hashtable tables = new Hashtable();
    private final Hashtable fields = new Hashtable();
    private final Object dataLock = new Object();
    private final NetworkQueue queue = new NetworkQueue();
    private final CountingQueue confirmations = new CountingQueue();
    private final NetworkQueue transaction = new NetworkQueue();
    private boolean connected = true;
    private boolean inTransaction = false;
    private boolean denyTransaction = false;
    private Watchdog watchdog;

    Connection(SocketConnection socket) {
        this.socket = socket;
    }

    Object getLock() {
        return this.dataLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offerTransaction(NetworkQueue transaction) {
        Object object = this.dataLock;
        synchronized (object) {
            LinkedList.Link link = transaction.queue.first;
            while (link != null) {
                if (link.data instanceof Entry.TableEntry) {
                    NetworkTable table = ((Entry)link.data).getTable();
                    table.addConnection(this);
                }
                link = link.next;
            }
            this.offer(Data.TRANSACTION_START);
            link = transaction.queue.first;
            while (link != null) {
                this.queue.offer((Data)link.data);
                link = link.next;
            }
            this.offer(Data.TRANSACTION_END);
            this.dataLock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void offer(Data data) {
        if (data != null) {
            Object object = this.dataLock;
            synchronized (object) {
                if (data instanceof Entry.TableEntry) {
                    NetworkTable table = ((Entry)data).getTable();
                    table.addConnection(this);
                }
                this.queue.offer(data);
                this.dataLock.notify();
            }
        }
    }

    void start() {
        this.watchdog = new Watchdog();
        this.watchdog.start();
        new Thread(){

            public void run() {
                try {
                    Connection.this.read(Connection.this.socket.openDataInputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Connection.this.close();
            }
        }.start();
        new Thread(){

            public void run() {
                try {
                    Connection.this.write(Connection.this.socket.openDataOutputStream());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Connection.this.close();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(InputStream stream) throws IOException {
        Reader input = new Reader(stream);
        while (this.connected) {
            Integer id;
            this.watchdog.feed();
            this.watchdog.activate();
            int value = input.read();
            if (value >= 128 || value == 9) {
                boolean oldData = value == 9;
                id = input.readId(!oldData);
                Key key = Key.getKey((Integer)this.fields.get(id));
                value = input.read();
                if (key == null) {
                    throw new IOException("Corrupted Data: No assignment for id:" + id);
                }
                ConnectionManager.getInstance().getClass();
                if (this.confirmations.containsKey(key)) {
                    if (this.inTransaction) {
                        this.denyTransaction = true;
                    } else {
                        this.offer(Denial.ONE);
                    }
                    if (value >= 64) {
                        input.readTableId(true);
                        continue;
                    }
                    input.readEntry(true);
                    continue;
                }
                if (value >= 64) {
                    Integer tableId = input.readTableId(true);
                    if (oldData && key.hasEntry()) {
                        this.offer(Denial.ONE);
                        continue;
                    }
                    NetworkTable table = this.getTable(false, tableId);
                    Entry.TableEntry entry = new Entry.TableEntry(table);
                    entry.setSource(this);
                    entry.setKey(key);
                    if (this.inTransaction) {
                        this.transaction.offer(entry);
                        continue;
                    }
                    key.getTable().got(false, key, entry);
                    this.offer(Confirmation.ONE);
                    continue;
                }
                Entry entry = input.readEntry(true);
                if (entry == null) {
                    throw new IOException("Corrupted Data: Could not interpret entry");
                }
                if (oldData && key.hasEntry()) {
                    this.offer(Denial.ONE);
                    continue;
                }
                entry.setSource(this);
                entry.setKey(key);
                if (this.inTransaction) {
                    this.transaction.offer(entry);
                    continue;
                }
                key.getTable().got(false, key, entry);
                this.offer(Confirmation.ONE);
                continue;
            }
            if (value >= 32) {
                int count = input.readConfirmations(true);
                while (count-- > 0) {
                    if (this.confirmations.isEmpty()) {
                        throw new IOException("Corrupted Data: Excess Confirmations");
                    }
                    Entry entry = this.confirmations.poll();
                    if (entry == null) {
                        ConnectionManager.getInstance().getClass();
                        while (this.confirmations.poll() != null) {
                        }
                        continue;
                    }
                    ConnectionManager.getInstance().getClass();
                }
                continue;
            }
            if (value >= 16) {
                ConnectionManager.getInstance().getClass();
                throw new IOException("Corrupted Data: The Server can not be denied");
            }
            if (value == 12) {
                ConnectionManager.getInstance().getClass();
                String name = input.readString();
                id = input.readTableId(false);
                NetworkTable table = NetworkTable.getTable(name);
                Object object = this.dataLock;
                synchronized (object) {
                    this.offer(new TableAssignment(table, id));
                    table.addConnection(this);
                }
                this.tables.put(id, table.getId());
                continue;
            }
            if (value == 3) {
                NetworkTable table = this.getTable(true, input.readTableId(false));
                id = input.readTableId(false);
                this.tables.put(id, table.getId());
                continue;
            }
            if (value == 6) {
                NetworkTable table = this.getTable(false, input.readTableId(false));
                Key key = table.getKey(input.readString());
                Integer id2 = input.readId(false);
                this.fields.put(id2, key.getId());
                continue;
            }
            if (value == 10) {
                this.inTransaction = !this.inTransaction;
                if (this.inTransaction) continue;
                if (this.denyTransaction) {
                    this.offer(Denial.ONE);
                } else {
                    if (!this.transaction.isEmpty()) {
                        ((Entry)this.transaction.peek()).getKey().getTable().processTransaction(false, this.transaction);
                    }
                    this.offer(Confirmation.ONE);
                }
                this.denyTransaction = false;
                continue;
            }
            throw new IOException("Corrupted Data: Don't know how to interpret marker byte (" + value + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkTable getTable(boolean local, Integer id) throws IOException {
        NetworkTable table;
        if (local) {
            table = NetworkTable.getTable(id);
        } else {
            Integer localId = (Integer)this.tables.get(id);
            if (localId == null) {
                table = new NetworkTable();
                this.tables.put(id, table.getId());
                Object object = this.dataLock;
                synchronized (object) {
                    this.offer(new TableAssignment(table, id));
                    table.addConnection(this);
                }
            } else {
                table = NetworkTable.getTable(localId);
            }
        }
        if (table == null) {
            throw new IOException("Corrupted Data: No " + (local ? "local" : "offboard") + " table found with id:" + id);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(OutputStream output) throws IOException {
        Buffer buffer = new Buffer(2048, output);
        boolean sentData = true;
        Data data = null;
        while (this.connected) {
            Object object = this.dataLock;
            synchronized (object) {
                data = this.queue.poll();
                if (data == null) {
                    if (sentData) {
                        sentData = false;
                    } else {
                        buffer.writeByte(32);
                        buffer.flush();
                    }
                    try {
                        this.dataLock.wait(250L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    continue;
                }
            }
            sentData = true;
            if (data instanceof Entry) {
                this.confirmations.offer((Entry)data);
            } else if (data instanceof OldData) {
                this.confirmations.offer(((OldData)data).entry);
            } else if (data == Data.TRANSACTION_START || data == Data.TRANSACTION_END) {
                this.confirmations.offer(null);
            }
            data.encode(buffer);
            buffer.flush();
        }
    }

    private synchronized void close() {
        if (this.connected) {
            this.connected = false;
            try {
                this.socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            Enumeration tableIds = this.tables.elements();
            while (tableIds.hasMoreElements()) {
                NetworkTable.getTable((Integer)tableIds.nextElement()).removeConnection(this);
            }
            ConnectionManager.getInstance().removeConnection(this);
        }
    }

    private class Watchdog
    extends Thread {
        private final Object lock = new Object();
        boolean active = false;
        boolean fed = false;

        private Watchdog() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                while (Connection.this.connected) {
                    while (!this.active) {
                        try {
                            this.lock.wait();
                        }
                        catch (InterruptedException ex) {}
                    }
                    this.fed = false;
                    try {
                        this.lock.wait(1000L);
                        if (this.fed) continue;
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                Connection.this.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void activate() {
            Object object = this.lock;
            synchronized (object) {
                if (!this.active) {
                    this.active = true;
                    this.lock.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void feed() {
            Object object = this.lock;
            synchronized (object) {
                this.active = false;
                this.fed = true;
                this.lock.notify();
            }
        }
    }
}

