/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.networktables;

import java.io.IOException;
import java.io.OutputStream;

class Buffer {
    private byte[] buffer;
    private int size;
    private OutputStream stream;

    public Buffer(int capacity, OutputStream output) {
        this.buffer = new byte[capacity];
        this.stream = output;
    }

    public void writeString(String entry) {
        if (entry.length() >= 255) {
            this.writeByte(255);
            this.writeBytes(entry.getBytes());
            this.writeByte(0);
        } else {
            this.writeByte(entry.length());
            this.writeBytes(entry.getBytes());
        }
    }

    public void writeDouble(double entry) {
        long l = Double.doubleToLongBits(entry);
        this.writeByte((int)(l >> 56 & 0xFFL));
        this.writeByte((int)(l >> 48 & 0xFFL));
        this.writeByte((int)(l >> 40 & 0xFFL));
        this.writeByte((int)(l >> 32 & 0xFFL));
        this.writeByte((int)(l >> 24 & 0xFFL));
        this.writeByte((int)(l >> 16 & 0xFFL));
        this.writeByte((int)(l >> 8 & 0xFFL));
        this.writeByte((int)(l & 0xFFL));
    }

    public void writeInt(int entry) {
        this.writeByte(entry >> 24 & 0xFF);
        this.writeByte(entry >> 16 & 0xFF);
        this.writeByte(entry >> 8 & 0xFF);
        this.writeByte(entry & 0xFF);
    }

    public void writeId(int id) {
        this.writeVariableSize(128, id);
    }

    public void writeTableId(int id) {
        this.writeVariableSize(64, id);
    }

    private void writeVariableSize(int tag, int id) {
        if (id < tag - 4) {
            this.writeByte(tag | id);
        } else {
            int fullTag = (tag | tag - 1) ^ 3;
            if (id < 256) {
                this.writeByte(fullTag);
                this.writeByte(id);
            } else if (id < 65536) {
                this.writeByte(fullTag | 1);
                this.writeByte(id >> 8);
                this.writeByte(id);
            } else if (id < 0x1000000) {
                this.writeByte(fullTag | 2);
                this.writeByte(id >> 16);
                this.writeByte(id >> 8);
                this.writeByte(id);
            } else {
                this.writeByte(fullTag | 3);
                this.writeByte(id >> 24);
                this.writeByte(id >> 16);
                this.writeByte(id >> 8);
                this.writeByte(id);
            }
        }
    }

    public void writeBytes(byte[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            this.writeByte(entries[i]);
        }
    }

    public void writeByte(int entry) {
        if (this.size >= this.buffer.length) {
            throw new BufferOverflowException("Attempted to write beyond the " + this.buffer.length + " byte limit.");
        }
        this.buffer[this.size++] = (byte)entry;
    }

    public void flush() throws IOException {
        this.stream.write(this.buffer, 0, this.size);
        this.stream.flush();
        this.clear();
    }

    public void clear() {
        this.size = 0;
    }

    public String toString() {
        String string = "[";
        for (int i = 0; i < this.size; ++i) {
            if (i != 0) {
                string = string + "-";
            }
            string = string + (this.buffer[i] & 0xFF);
        }
        return string + "]";
    }

    public static class BufferOverflowException
    extends IndexOutOfBoundsException {
        public BufferOverflowException(String message) {
            super(message);
        }
    }
}

