/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.command;

import edu.wpi.first.wpilibj.buttons.Button;
import edu.wpi.first.wpilibj.command.Command;
import edu.wpi.first.wpilibj.command.LinkedListElement;
import edu.wpi.first.wpilibj.command.Set;
import edu.wpi.first.wpilibj.command.Subsystem;
import edu.wpi.first.wpilibj.networktables.NetworkTable;
import edu.wpi.first.wpilibj.smartdashboard.SmartDashboardNamedData;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Scheduler
implements SmartDashboardNamedData {
    private static Scheduler instance;
    private Hashtable commandTable = new Hashtable();
    private Set subsystems = new Set();
    private LinkedListElement firstCommand;
    private LinkedListElement lastCommand;
    private boolean adding = false;
    private Vector additions = new Vector();
    private Vector buttons;
    private NetworkTable table;

    public static synchronized Scheduler getInstance() {
        return instance == null ? (instance = new Scheduler()) : instance;
    }

    private Scheduler() {
    }

    public void add(Command command) {
        if (command != null) {
            this.additions.addElement(command);
        }
    }

    public void addButton(Button.ButtonScheduler button) {
        if (this.buttons == null) {
            this.buttons = new Vector();
        }
        this.buttons.addElement(button);
    }

    private void _add(Command command) {
        if (command == null) {
            return;
        }
        if (this.adding) {
            System.err.println("WARNING: Can not start command from cancel method.  Ignoring:" + command);
            return;
        }
        if (!this.commandTable.containsKey(command)) {
            Subsystem lock;
            Enumeration requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() == null || lock.getCurrentCommand().isInterruptible()) continue;
                return;
            }
            this.adding = true;
            requirements = command.getRequirements();
            while (requirements.hasMoreElements()) {
                lock = (Subsystem)requirements.nextElement();
                if (lock.getCurrentCommand() != null) {
                    lock.getCurrentCommand().cancel();
                    this.remove(lock.getCurrentCommand());
                }
                lock.setCurrentCommand(command);
            }
            this.adding = false;
            LinkedListElement element = new LinkedListElement();
            element.setData(command);
            if (this.firstCommand == null) {
                this.firstCommand = this.lastCommand = element;
            } else {
                this.lastCommand.add(element);
                this.lastCommand = element;
            }
            this.commandTable.put(command, element);
            command.startRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        LinkedListElement e;
        if (this.buttons != null) {
            for (int i = this.buttons.size() - 1; i >= 0; --i) {
                ((Button.ButtonScheduler)this.buttons.elementAt(i)).execute();
            }
        }
        for (e = this.firstCommand; e != null; e = e.getNext()) {
            Command c = e.getData();
            if (c.run()) continue;
            this.remove(c);
        }
        if (this.table != null) {
            int count = 0;
            NetworkTable networkTable = this.table;
            synchronized (networkTable) {
                this.table.beginTransaction();
                for (e = this.firstCommand; e != null; e = e.getNext()) {
                    this.table.putSubTable(String.valueOf(++count), e.getData().getTable());
                }
                this.table.putInt("count", count);
                this.table.endTransaction();
            }
        }
        for (int i = 0; i < this.additions.size(); ++i) {
            this._add((Command)this.additions.elementAt(i));
        }
        this.additions.removeAllElements();
        Enumeration locks = this.subsystems.getElements();
        while (locks.hasMoreElements()) {
            Subsystem lock = (Subsystem)locks.nextElement();
            if (lock.getCurrentCommand() == null) {
                this._add(lock.getDefaultCommand());
            }
            lock.confirmCommand();
        }
    }

    void registerSubsystem(Subsystem system) {
        if (system != null) {
            this.subsystems.add(system);
        }
    }

    void remove(Command command) {
        if (command == null || !this.commandTable.containsKey(command)) {
            return;
        }
        LinkedListElement e = (LinkedListElement)this.commandTable.get(command);
        this.commandTable.remove(command);
        if (e.equals(this.lastCommand)) {
            this.lastCommand = e.getPrevious();
        }
        if (e.equals(this.firstCommand)) {
            this.firstCommand = e.getNext();
        }
        e.remove();
        Enumeration requirements = command.getRequirements();
        while (requirements.hasMoreElements()) {
            ((Subsystem)requirements.nextElement()).setCurrentCommand(null);
        }
        command.removed();
    }

    public String getName() {
        return "Scheduler";
    }

    public String getType() {
        return "Scheduler";
    }

    public NetworkTable getTable() {
        if (this.table == null) {
            this.table = new NetworkTable();
            this.table.putInt("count", 0);
        }
        return this.table;
    }
}

