/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Solenoid
extends SolenoidBase {
    private int m_channel;

    private synchronized void initSolenoid() {
        Solenoid.checkSolenoidModule(this.m_moduleNumber);
        Solenoid.checkSolenoidChannel(this.m_channel);
        try {
            m_allocated.allocate((this.m_moduleNumber - 1) * 8 + this.m_channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_channel + " on module " + this.m_moduleNumber + " is already allocated");
        }
    }

    public Solenoid(int channel) {
        super(Solenoid.getDefaultSolenoidModule());
        this.m_channel = channel;
        this.initSolenoid();
    }

    public Solenoid(int moduleNumber, int channel) {
        super(moduleNumber);
        this.m_channel = channel;
        this.initSolenoid();
    }

    public synchronized void free() {
        m_allocated.free((this.m_moduleNumber - 1) * 8 + this.m_channel - 1);
    }

    public void set(boolean on) {
        byte value = (byte)(on ? 255 : 0);
        byte mask = (byte)(1 << this.m_channel - 1);
        this.set(value, mask);
    }

    public boolean get() {
        int value = this.getAll() & 1 << this.m_channel - 1;
        return value != 0;
    }
}

