/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.PIDOutput;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.parsing.IUtility;
import edu.wpi.first.wpilibj.util.BoundaryException;
import java.util.Timer;
import java.util.TimerTask;

public class PIDController
implements IUtility {
    public static final double kDefaultPeriod = 0.05;
    private double m_P;
    private double m_I;
    private double m_D;
    private double m_maximumOutput = 1.0;
    private double m_minimumOutput = -1.0;
    private double m_maximumInput = 0.0;
    private double m_minimumInput = 0.0;
    private boolean m_continuous = false;
    private boolean m_enabled = false;
    private double m_prevError = 0.0;
    private double m_totalError = 0.0;
    private double m_tolerance = 0.05;
    private double m_setpoint = 0.0;
    private double m_error = 0.0;
    private double m_result = 0.0;
    private double m_period = 0.05;
    PIDSource m_pidInput;
    PIDOutput m_pidOutput;
    Timer m_controlLoop;

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output, double period) {
        if (source == null) {
            throw new NullPointerException("Null PIDSource was given");
        }
        if (output == null) {
            throw new NullPointerException("Null PIDOutput was given");
        }
        this.m_controlLoop = new Timer();
        this.m_P = Kp;
        this.m_I = Ki;
        this.m_D = Kd;
        this.m_pidInput = source;
        this.m_pidOutput = output;
        this.m_period = period;
        this.m_controlLoop.schedule((TimerTask)new PIDTask(this), 0L, (long)(this.m_period * 1000.0));
    }

    public PIDController(double Kp, double Ki, double Kd, PIDSource source, PIDOutput output) {
        this(Kp, Ki, Kd, source, output, 0.05);
    }

    public void free() {
        this.m_controlLoop.cancel();
        this.m_controlLoop = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculate() {
        PIDSource pidInput;
        boolean enabled;
        PIDController pIDController = this;
        synchronized (pIDController) {
            if (this.m_pidInput == null) {
                return;
            }
            if (this.m_pidOutput == null) {
                return;
            }
            enabled = this.m_enabled;
            pidInput = this.m_pidInput;
        }
        if (enabled) {
            double result;
            double input = pidInput.pidGet();
            PIDOutput pidOutput = null;
            PIDController pIDController2 = this;
            synchronized (pIDController2) {
                this.m_error = this.m_setpoint - input;
                if (this.m_continuous && Math.abs(this.m_error) > (this.m_maximumInput - this.m_minimumInput) / 2.0) {
                    this.m_error = this.m_error > 0.0 ? this.m_error - this.m_maximumInput + this.m_minimumInput : this.m_error + this.m_maximumInput - this.m_minimumInput;
                }
                if ((this.m_totalError + this.m_error) * this.m_I < this.m_maximumOutput && (this.m_totalError + this.m_error) * this.m_I > this.m_minimumOutput) {
                    this.m_totalError += this.m_error;
                }
                this.m_result = this.m_P * this.m_error + this.m_I * this.m_totalError + this.m_D * (this.m_error - this.m_prevError);
                this.m_prevError = this.m_error;
                if (this.m_result > this.m_maximumOutput) {
                    this.m_result = this.m_maximumOutput;
                } else if (this.m_result < this.m_minimumOutput) {
                    this.m_result = this.m_minimumOutput;
                }
                pidOutput = this.m_pidOutput;
                result = this.m_result;
            }
            pidOutput.pidWrite(result);
        }
    }

    public synchronized void setPID(double p, double i, double d) {
        this.m_P = p;
        this.m_I = i;
        this.m_D = d;
    }

    public double getP() {
        return this.m_P;
    }

    public double getI() {
        return this.m_I;
    }

    public synchronized double getD() {
        return this.m_D;
    }

    public synchronized double get() {
        return this.m_result;
    }

    public synchronized void setContinuous(boolean continuous) {
        this.m_continuous = continuous;
    }

    public synchronized void setContinuous() {
        this.setContinuous(true);
    }

    public synchronized void setInputRange(double minimumInput, double maximumInput) {
        if (minimumInput > maximumInput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumInput = minimumInput;
        this.m_maximumInput = maximumInput;
        this.setSetpoint(this.m_setpoint);
    }

    public synchronized void setOutputRange(double minimumOutput, double maximumOutput) {
        if (minimumOutput > maximumOutput) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_minimumOutput = minimumOutput;
        this.m_maximumOutput = maximumOutput;
    }

    public synchronized void setSetpoint(double setpoint) {
        this.m_setpoint = this.m_maximumInput > this.m_minimumInput ? (setpoint > this.m_maximumInput ? this.m_maximumInput : (setpoint < this.m_minimumInput ? this.m_minimumInput : setpoint)) : setpoint;
    }

    public synchronized double getSetpoint() {
        return this.m_setpoint;
    }

    public synchronized double getError() {
        return this.m_error;
    }

    public synchronized void setTolerance(double percent) {
        this.m_tolerance = percent;
    }

    public synchronized boolean onTarget() {
        return Math.abs(this.m_error) < this.m_tolerance / 100.0 * (this.m_maximumInput - this.m_minimumInput);
    }

    public synchronized void enable() {
        this.m_enabled = true;
    }

    public synchronized void disable() {
        this.m_pidOutput.pidWrite(0.0);
        this.m_enabled = false;
    }

    public synchronized boolean isEnable() {
        return this.m_enabled;
    }

    public synchronized void reset() {
        this.disable();
        this.m_prevError = 0.0;
        this.m_totalError = 0.0;
        this.m_result = 0.0;
    }

    private class PIDTask
    extends TimerTask {
        private PIDController m_controller;

        public PIDTask(PIDController controller) {
            if (controller == null) {
                throw new NullPointerException("Given PIDController was null");
            }
            this.m_controller = controller;
        }

        public void run() {
            this.m_controller.calculate();
        }
    }
}

