/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class I2C
extends SensorBase {
    private DigitalModule m_module;
    private int m_deviceAddress;
    private boolean m_compatibilityMode;

    public I2C(DigitalModule module, int deviceAddress) {
        if (module == null) {
            throw new NullPointerException("Digital Module given was null");
        }
        this.m_module = module;
        this.m_deviceAddress = deviceAddress;
        this.m_compatibilityMode = false;
    }

    public void free() {
    }

    public synchronized boolean transaction(byte[] dataToSend, int sendSize, byte[] dataReceived, int receiveSize) {
        int i;
        BoundaryException.assertWithinBounds(sendSize, 0.0, 6.0);
        BoundaryException.assertWithinBounds(receiveSize, 0.0, 7.0);
        long data = 0L;
        long dataHigh = 0L;
        for (i = 0; i < sendSize && i < 4; ++i) {
            data |= (long)dataToSend[i] << 8 * i;
        }
        while (i < sendSize) {
            dataHigh |= (long)dataToSend[i] << 8 * (i - 4);
            ++i;
        }
        boolean aborted = true;
        this.m_module.m_fpgaDIO.writeI2CConfig_Address(this.m_deviceAddress);
        this.m_module.m_fpgaDIO.writeI2CConfig_BytesToWrite(sendSize);
        this.m_module.m_fpgaDIO.writeI2CConfig_BytesToRead(receiveSize);
        if (sendSize > 0) {
            this.m_module.m_fpgaDIO.writeI2CDataToSend(data);
        }
        if (sendSize > 4) {
            this.m_module.m_fpgaDIO.writeI2CConfig_DataToSendHigh((int)dataHigh);
        }
        this.m_module.m_fpgaDIO.writeI2CConfig_BitwiseHandshake(this.m_compatibilityMode);
        byte transaction = this.m_module.m_fpgaDIO.readI2CStatus_Transaction();
        this.m_module.m_fpgaDIO.strobeI2CStart();
        while (transaction == this.m_module.m_fpgaDIO.readI2CStatus_Transaction()) {
            Timer.delay(0.001);
        }
        while (!this.m_module.m_fpgaDIO.readI2CStatus_Done()) {
            Timer.delay(0.001);
        }
        aborted = this.m_module.m_fpgaDIO.readI2CStatus_Aborted();
        if (receiveSize > 0) {
            data = this.m_module.m_fpgaDIO.readI2CDataReceived();
        }
        if (receiveSize > 4) {
            dataHigh = this.m_module.m_fpgaDIO.readI2CStatus_DataReceivedHigh();
        }
        for (i = 0; i < receiveSize && i < 4; ++i) {
            dataReceived[i] = (byte)(data >> 8 * i & 0xFFL);
        }
        while (i < receiveSize) {
            dataReceived[i] = (byte)(dataHigh >> 8 * (i - 4) & 0xFFL);
            ++i;
        }
        return aborted;
    }

    public boolean addressOnly() {
        return this.transaction(null, 0, null, 0);
    }

    public synchronized boolean write(int registerAddress, int data) {
        byte[] buffer = new byte[]{(byte)registerAddress, (byte)data};
        return this.transaction(buffer, buffer.length, null, 0);
    }

    public boolean read(int registerAddress, int count, byte[] buffer) {
        BoundaryException.assertWithinBounds(count, 1.0, 7.0);
        if (buffer == null) {
            throw new NullPointerException("Null return buffer was given");
        }
        byte[] registerAddressArray = new byte[]{(byte)registerAddress};
        return this.transaction(registerAddressArray, registerAddressArray.length, buffer, count);
    }

    public void broadcast(int registerAddress, int data) {
    }

    public void setCompatabilityMode(boolean enable) {
        this.m_compatibilityMode = enable;
    }

    public boolean verifySensor(int registerAddress, int count, byte[] expected) {
        byte[] deviceData = new byte[4];
        int i = 0;
        int curRegisterAddress = registerAddress;
        while (i < count) {
            int toRead;
            int n = toRead = count - i < 4 ? count - i : 4;
            if (this.read(curRegisterAddress, toRead, deviceData)) {
                return false;
            }
            for (int j = 0; j < toRead; j = (int)((byte)(j + 1))) {
                if (deviceData[j] == expected[i + j]) continue;
                return false;
            }
            i += 4;
            curRegisterAddress += 4;
        }
        return true;
    }
}

