/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.squawk.util.MathUtils;
import edu.wpi.first.wpilibj.I2C;
import edu.wpi.first.wpilibj.Module;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.ModulePresence;
import edu.wpi.first.wpilibj.fpga.tDIO;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class DigitalModule
extends Module {
    public static final int kExpectedLoopTiming = 261;
    private static final Resource DIOChannels = new Resource(28);
    private static final Resource[] DO_PWMGenerators = new Resource[2];
    tDIO m_fpgaDIO;
    private final Object syncRoot = new Object();

    public static synchronized DigitalModule getInstance(int moduleNumber) {
        SensorBase.checkDigitalModule(moduleNumber);
        return (DigitalModule)DigitalModule.getModule(ModulePresence.ModuleType.kDigital, moduleNumber);
    }

    public static int remapDigitalChannel(int channel) {
        return 15 - channel;
    }

    public static int unmapDigitalChannel(int channel) {
        return 15 - channel;
    }

    protected DigitalModule(int moduleNumber) {
        super(ModulePresence.ModuleType.kDigital, moduleNumber);
        DigitalModule.DO_PWMGenerators[this.m_moduleNumber - 1] = new Resource(4);
        this.m_fpgaDIO = new tDIO(this.m_moduleNumber - 1);
        while (tDIO.readLoopTiming() == 0) {
            Timer.delay(0.001);
        }
        if (tDIO.readLoopTiming() != 261) {
            System.out.print("DIO LoopTiming: ");
            System.out.print(tDIO.readLoopTiming());
            System.out.print(", expecting: ");
            System.out.println(261);
        }
        tDIO.writePWMConfig_Period(774);
        tDIO.writePWMConfig_MinHigh(102);
        for (int pwm_index = 1; pwm_index <= 10; ++pwm_index) {
            this.setPWM(pwm_index, 0);
            this.setPWMPeriodScale(pwm_index, 4);
        }
        this.m_fpgaDIO.writeSlowValue_RelayFwd(0);
        this.m_fpgaDIO.writeSlowValue_RelayRev(0);
    }

    public void setPWM(int channel, int value) {
        DigitalModule.checkPWMChannel(channel);
        this.m_fpgaDIO.writePWMValue(channel - 1, value);
    }

    public int getPWM(int channel) {
        DigitalModule.checkPWMChannel(channel);
        return this.m_fpgaDIO.readPWMValue(channel - 1);
    }

    public void setPWMPeriodScale(int channel, int squelchMask) {
        DigitalModule.checkPWMChannel(channel);
        this.m_fpgaDIO.writePWMPeriodScale((byte)(channel - 1), squelchMask);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelayForward(int channel, boolean on) {
        DigitalModule.checkRelayChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            int forwardRelays = this.m_fpgaDIO.readSlowValue_RelayFwd();
            forwardRelays = on ? (forwardRelays |= 1 << channel - 1) : (forwardRelays &= ~(1 << channel - 1));
            this.m_fpgaDIO.writeSlowValue_RelayFwd(forwardRelays);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRelayReverse(int channel, boolean on) {
        SensorBase.checkRelayChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            int reverseRelays = this.m_fpgaDIO.readSlowValue_RelayRev();
            reverseRelays = on ? (reverseRelays |= 1 << channel - 1) : (reverseRelays &= ~(1 << channel - 1));
            this.m_fpgaDIO.writeSlowValue_RelayRev(reverseRelays);
        }
    }

    public boolean getRelayForward(int channel) {
        short forwardRelays = this.m_fpgaDIO.readSlowValue_RelayFwd();
        return (forwardRelays & 1 << channel - 1) != 0;
    }

    public byte getRelayForward() {
        return (byte)this.m_fpgaDIO.readSlowValue_RelayFwd();
    }

    public boolean getRelayReverse(int channel) {
        short reverseRelays = this.m_fpgaDIO.readSlowValue_RelayRev();
        return (reverseRelays & 1 << channel - 1) != 0;
    }

    public byte getRelayReverse() {
        return (byte)this.m_fpgaDIO.readSlowValue_RelayRev();
    }

    public boolean allocateDIO(int channel, boolean input) {
        try {
            DIOChannels.allocate(14 * (this.m_moduleNumber - 1) + channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Digital channel " + channel + " on module " + this.m_moduleNumber + " is already allocated");
        }
        int outputEnable = this.m_fpgaDIO.readOutputEnable();
        int bitToSet = 1 << DigitalModule.remapDigitalChannel(channel - 1);
        short outputEnableValue = input ? (short)(outputEnable & ~bitToSet) : (short)(outputEnable | bitToSet);
        this.m_fpgaDIO.writeOutputEnable(outputEnableValue);
        return true;
    }

    public void freeDIO(int channel) {
        DIOChannels.free(14 * (this.m_moduleNumber - 1) + channel - 1);
    }

    public void setDIO(int channel, boolean value) {
        int currentDIO = this.m_fpgaDIO.readDO();
        currentDIO = !value ? (currentDIO &= ~(1 << DigitalModule.remapDigitalChannel(channel - 1))) : (currentDIO |= 1 << DigitalModule.remapDigitalChannel(channel - 1));
        this.m_fpgaDIO.writeDO(currentDIO);
    }

    public boolean getDIO(int channel) {
        int currentDIO = this.m_fpgaDIO.readDI();
        return (currentDIO >> DigitalModule.remapDigitalChannel(channel - 1) & 1) == 1;
    }

    public short getAllDIO() {
        return (short)this.m_fpgaDIO.readDI();
    }

    public boolean getDIODirection(int channel) {
        int currentOutputEnable = this.m_fpgaDIO.readOutputEnable();
        return (currentOutputEnable >> DigitalModule.remapDigitalChannel(channel - 1) & 1) != 0;
    }

    public short getDIODirection() {
        return (short)this.m_fpgaDIO.readOutputEnable();
    }

    public void pulse(int channel, int pulseLength) {
        short mask = (short)(1 << DigitalModule.remapDigitalChannel(channel - 1));
        this.m_fpgaDIO.writePulseLength(pulseLength);
        this.m_fpgaDIO.writePulse(mask);
    }

    public boolean isPulsing(int channel) {
        int mask = 1 << DigitalModule.remapDigitalChannel(channel - 1);
        int pulseRegister = this.m_fpgaDIO.readPulse();
        return (pulseRegister & mask) != 0;
    }

    public boolean isPulsing() {
        int pulseRegister = this.m_fpgaDIO.readPulse();
        return pulseRegister != 0;
    }

    public int allocateDO_PWM() {
        try {
            return DO_PWMGenerators[this.m_moduleNumber - 1].allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No Digital Output PWM Generators on module " + this.m_moduleNumber + " remaining");
        }
    }

    public void freeDO_PWM(int pwmGenerator) {
        if (pwmGenerator == -1) {
            return;
        }
        DO_PWMGenerators[this.m_moduleNumber - 1].free(pwmGenerator);
    }

    public void setDO_PWMRate(double rate) {
        DigitalModule digitalModule = this;
        byte pwmPeriodPower = (byte)(MathUtils.log((double)(1.0 / ((double)digitalModule.m_fpgaDIO.readLoopTiming() * 2.5E-7 * rate))) / MathUtils.log((double)2.0) + 0.5);
        this.m_fpgaDIO.writeDO_PWMConfig_PeriodPower(pwmPeriodPower);
    }

    public void setDO_PWMOutputChannel(int pwmGenerator, int channel) {
        if (pwmGenerator == -1) {
            return;
        }
        switch (pwmGenerator) {
            case 0: {
                this.m_fpgaDIO.writeDO_PWMConfig_OutputSelect_0(DigitalModule.remapDigitalChannel(channel - 1));
                break;
            }
            case 1: {
                this.m_fpgaDIO.writeDO_PWMConfig_OutputSelect_1(DigitalModule.remapDigitalChannel(channel - 1));
                break;
            }
            case 2: {
                this.m_fpgaDIO.writeDO_PWMConfig_OutputSelect_2(DigitalModule.remapDigitalChannel(channel - 1));
                break;
            }
            case 3: {
                this.m_fpgaDIO.writeDO_PWMConfig_OutputSelect_3(DigitalModule.remapDigitalChannel(channel - 1));
            }
        }
    }

    public void setDO_PWMDutyCycle(int pwmGenerator, double dutyCycle) {
        byte pwmPeriodPower;
        double rawDutyCycle;
        if (pwmGenerator == -1) {
            return;
        }
        if (dutyCycle > 1.0) {
            dutyCycle = 1.0;
        }
        if (dutyCycle < 0.0) {
            dutyCycle = 0.0;
        }
        if ((rawDutyCycle = 256.0 * dutyCycle) > 255.5) {
            rawDutyCycle = 255.5;
        }
        if ((pwmPeriodPower = this.m_fpgaDIO.readDO_PWMConfig_PeriodPower()) < 4) {
            rawDutyCycle /= MathUtils.pow((double)2.0, (double)(4 - pwmPeriodPower));
        }
        this.m_fpgaDIO.writeDO_PWMDutyCycle(pwmGenerator, (byte)rawDutyCycle);
    }

    public I2C getI2C(int address) {
        return new I2C(this, address);
    }
}

