/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.AnalogModule;
import edu.wpi.first.wpilibj.AnalogTriggerOutput;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.fpga.tAnalogTrigger;
import edu.wpi.first.wpilibj.parsing.IInputOutput;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.BoundaryException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class AnalogTrigger
implements IInputOutput {
    private static Resource triggers = new Resource(8);
    protected int m_index;
    private tAnalogTrigger m_trigger;
    private AnalogModule m_analogModule;
    private int m_channel;

    protected void initTrigger(int moduleNumber, int channel) {
        this.m_channel = channel;
        this.m_analogModule = AnalogModule.getInstance(moduleNumber);
        try {
            this.m_index = triggers.allocate();
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("No analog triggers are available to allocate");
        }
        this.m_trigger = new tAnalogTrigger((byte)this.m_index);
        this.m_trigger.writeSourceSelect_Channel((byte)(this.m_channel - 1));
        this.m_trigger.writeSourceSelect_Module((byte)moduleNumber - 1);
    }

    public AnalogTrigger(int channel) {
        this.initTrigger(AnalogModule.getDefaultAnalogModule(), channel);
    }

    public AnalogTrigger(int moduleNumber, int channel) {
        this.initTrigger(moduleNumber, channel);
    }

    public AnalogTrigger(AnalogChannel channel) {
        this.initTrigger(channel.getModuleNumber(), channel.getChannel());
    }

    public void free() {
        triggers.free(this.m_index);
        this.m_trigger.Release();
        this.m_trigger = null;
    }

    public void setLimitsRaw(int lower, int upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper");
        }
        this.m_trigger.writeLowerLimit(lower);
        this.m_trigger.writeUpperLimit(upper);
    }

    public void setLimitsVoltage(double lower, double upper) {
        if (lower > upper) {
            throw new BoundaryException("Lower bound is greater than upper bound");
        }
        this.m_trigger.writeLowerLimit(this.m_analogModule.voltsToValue(this.m_channel, lower));
        this.m_trigger.writeUpperLimit(this.m_analogModule.voltsToValue(this.m_channel, upper));
    }

    public void setAveraged(boolean useAveragedValue) {
        if (this.m_trigger.readSourceSelect_Filter() && useAveragedValue) {
            throw new AnalogTriggerException("Cannot set to Averaged if the analog trigger is filtered");
        }
        this.m_trigger.writeSourceSelect_Averaged(useAveragedValue);
    }

    public void setFiltered(boolean useFilteredValue) {
        if (this.m_trigger.readSourceSelect_Averaged() && useFilteredValue) {
            throw new AnalogTriggerException("Cannot set to Filtered if the analog trigger is averaged");
        }
        this.m_trigger.writeSourceSelect_Filter(useFilteredValue);
    }

    public int getIndex() {
        return this.m_index;
    }

    public boolean getInWindow() {
        return tAnalogTrigger.readOutput_InHysteresis((byte)this.m_index);
    }

    public boolean getTriggerState() {
        return tAnalogTrigger.readOutput_OverLimit((byte)this.m_index);
    }

    AnalogTriggerOutput createOutput(AnalogTriggerOutput.Type type) {
        return new AnalogTriggerOutput(this, type);
    }

    public class AnalogTriggerException
    extends RuntimeException {
        public AnalogTriggerException(String message) {
            super(message);
        }
    }
}

