/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.Module;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.communication.AICalibration;
import edu.wpi.first.wpilibj.communication.ModulePresence;
import edu.wpi.first.wpilibj.fpga.tAI;

public class AnalogModule
extends Module {
    public static final int kTimebase = 40000000;
    public static final int kDefaultOversampleBits = 0;
    public static final int kDefaultAverageBits = 7;
    public static final double kDefaultSampleRate = 50000.0;
    private tAI m_module;
    private boolean m_sampleRateSet;
    private long m_accumulatorOffset;
    private int m_numChannelsToActivate;
    private final Object syncRoot = new Object();

    public static synchronized AnalogModule getInstance(int moduleNumber) {
        AnalogModule.checkAnalogModule(moduleNumber);
        return (AnalogModule)AnalogModule.getModule(ModulePresence.ModuleType.kAnalog, moduleNumber);
    }

    protected AnalogModule(int moduleNumber) {
        super(ModulePresence.ModuleType.kAnalog, moduleNumber);
        this.m_module = new tAI(moduleNumber - 1);
        this.setNumChannelsToActivate(8);
        this.setSampleRate(50000.0);
        for (int i = 0; i < 8; ++i) {
            this.m_module.writeScanList(i, i);
            this.setAverageBits(i + 1, 7);
            this.setOversampleBits(i + 1, 0);
        }
    }

    public void setSampleRate(double samplesPerSecond) {
        this.m_sampleRateSet = true;
        int ticksPerSample = (int)(4.0E7 / samplesPerSecond);
        int ticksPerConversion = ticksPerSample / this.getNumChannelsToActivate();
        if (ticksPerConversion < 80) {
            ticksPerConversion = 80;
        }
        this.m_module.writeConfig_ScanSize(this.getNumChannelsToActivate());
        this.m_module.writeConfig_ConvertRate(ticksPerConversion);
        this.setNumChannelsToActivate(0);
    }

    public double getSampleRate() {
        long ticksPerConversion = this.m_module.readLoopTiming();
        long ticksPerSample = ticksPerConversion * (long)this.getNumActiveChannels();
        return 4.0E7 / (double)ticksPerSample;
    }

    private int getNumActiveChannels() {
        byte scanSize = this.m_module.readConfig_ScanSize();
        return scanSize == 0 ? 8 : (int)scanSize;
    }

    private int getNumChannelsToActivate() {
        if (this.m_numChannelsToActivate == 0) {
            return this.getNumActiveChannels();
        }
        return this.m_numChannelsToActivate;
    }

    private void setNumChannelsToActivate(int channels) {
        this.m_numChannelsToActivate = channels;
    }

    public void setAverageBits(int channel, int bits) {
        this.m_module.writeAverageBits(channel - 1, bits);
    }

    public int getAverageBits(int channel) {
        return this.m_module.readAverageBits(channel - 1);
    }

    public void setOversampleBits(int channel, int bits) {
        this.m_module.writeOversampleBits(channel - 1, bits);
    }

    public int getOversampleBits(int channel) {
        return this.m_module.readOversampleBits(channel - 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getValue(int channel) {
        int value;
        SensorBase.checkAnalogChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            tAI.writeReadSelect_Channel(channel - 1);
            tAI.writeReadSelect_Module(this.m_moduleNumber - 1);
            tAI.writeReadSelect_Averaged(false);
            tAI.strobeLatchOutput();
            value = tAI.readOutput();
        }
        return (short)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAverageValue(int channel) {
        int value;
        SensorBase.checkAnalogChannel(channel);
        Object object = this.syncRoot;
        synchronized (object) {
            tAI.writeReadSelect_Channel(channel - 1);
            tAI.writeReadSelect_Module(this.m_moduleNumber - 1);
            tAI.writeReadSelect_Averaged(true);
            tAI.strobeLatchOutput();
            value = tAI.readOutput();
        }
        return value;
    }

    public int voltsToValue(int channel, double voltage) {
        long LSBWeight = this.getLSBWeight(channel);
        int offset = this.getOffset(channel);
        int value = (int)((voltage + (double)offset * 1.0E-9) / ((double)LSBWeight * 1.0E-9));
        return value;
    }

    public double getVoltage(int channel) {
        int value = this.getValue(channel);
        long LSBWeight = this.getLSBWeight(channel);
        int offset = this.getOffset(channel);
        double voltage = (double)LSBWeight * 1.0E-9 * (double)value - (double)offset * 1.0E-9;
        return voltage;
    }

    public double getAverageVoltage(int channel) {
        int value = this.getAverageValue(channel);
        long LSBWeight = this.getLSBWeight(channel);
        int offset = this.getOffset(channel);
        int oversampleBits = this.getOversampleBits(channel);
        double voltage = (double)LSBWeight * 1.0E-9 * (double)value / (double)(1 << oversampleBits) - (double)offset * 1.0E-9;
        return voltage;
    }

    public long getLSBWeight(int channel) {
        return AICalibration.getLSBWeight(this.m_module.getSystemIndex(), channel - 1);
    }

    public int getOffset(int channel) {
        return AICalibration.getOffset(this.m_module.getSystemIndex(), channel - 1);
    }
}

