/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2008. All Rights Reserved.							  */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in $(WIND_BASE)/WPILib.  */
/*----------------------------------------------------------------------------*/

#ifndef JOYSTICK_H_
#define JOYSTICK_H_

#include "SimInterface.h"

/**
 * Handle input from standard Joysticks connected to the Driver Station.
 * This class handles standard input that comes from the Driver Station. Each time a value is requested
 * the most recent value is returned. There is a single class instance for each joystick and the mapping
 * of ports to hardware buttons depends on the code in the driver station.
 */
class Joystick
{
public:
	//TODO: static const UINT32 kDefaultXAxis = 1;
	//TODO: static const UINT32 kDefaultYAxis = 2;
	//TODO: static const UINT32 kDefaultZAxis = 3;
	//TODO: static const UINT32 kDefaultTwistAxis = 4;
	//TODO: static const UINT32 kDefaultThrottleAxis = 3;
	//TODO: typedef enum
	//TODO: {
	//TODO: 	kXAxis, kYAxis, kZAxis, kTwistAxis, kThrottleAxis, kNumAxisTypes
	//TODO: } AxisType;
	//TODO: static const UINT32 kDefaultTriggerButton = 1;
	//TODO: static const UINT32 kDefaultTopButton = 2;
	//TODO: typedef enum
	//TODO: {
	//TODO: 	kTriggerButton, kTopButton, kNumButtonTypes
	//TODO: } ButtonType;

	Joystick(UINT32 port) : m_port( port ) { }
        
	//TODO: Joystick(UINT32 port, UINT32 numAxisTypes, UINT32 numButtonTypes);
	//TODO: virtual ~Joystick();

	//TODO: UINT32 GetAxisChannel(AxisType axis);
	//TODO: void SetAxisChannel(AxisType axis, UINT32 channel); 

	virtual float GetX() { return( SimInterface::GetJoystickAxis( m_port, SimInterface::X_AXIS ) ); }
	virtual float GetY() { return( SimInterface::GetJoystickAxis( m_port, SimInterface::Y_AXIS ) ); }
	virtual float GetZ() { return( SimInterface::GetJoystickAxis( m_port, SimInterface::Z_AXIS ) ); }
	//TODO: virtual float GetTwist();
	//TODO: virtual float GetThrottle();
	//TODO: virtual float GetAxis(AxisType axis);
	float GetRawAxis(UINT32 axis) { return( SimInterface::GetJoystickAxis( m_port, SimInterface::joystick_axis_type( axis ) ) ); }

	virtual bool GetTrigger() { return( SimInterface::GetJoystickButton( m_port, 0 ) ); }
	//TODO: virtual bool GetTop();
	//TODO: virtual bool GetBumper();
	//TODO: virtual bool GetButton(ButtonType button);
	bool GetRawButton(UINT32 button) { return( SimInterface::GetJoystickButton( m_port, button ) ); }
	//TODO: static Joystick* GetStickForPort(UINT32 port);

private:
	//TODO: void InitJoystick(UINT32 numAxisTypes, UINT32 numButtonTypes);

	UINT32 m_port;
	//TODO: UINT32 *m_axes;
	//TODO: UINT32 *m_buttons;
};

#endif
 
