/*----------------------------------------------------------------------------*/
/* Copyright (c) FIRST 2008. All Rights Reserved.							  */
/* Open Source Software - may be modified and shared by FRC teams. The code   */
/* must be accompanied by the FIRST BSD license file in $(WIND_BASE)/WPILib.  */
/*                                                                            */
/* Modified by Alex Morozov for the robot simulator program                   */
/* Note that only one gyro is supported at this time.  No matter how many     */
/* gyros you instantiate, they all will return the same reading.              */
/*----------------------------------------------------------------------------*/

#ifndef GYRO_H_
#define GYRO_H_

#include "CppBot_types.h"

/**
 * Use a rate gyro to return the robots heading relative to a starting position.
 * The Gyro class tracks the robots heading based on the starting position. As the robot
 * rotates the new heading is computed by integrating the rate of rotation returned
 * by the sensor. When the class is instantiated, it does a short calibration routine
 * where it samples the gyro while at rest to determine the default offset. This is
 * subtracted from each sample to determine the heading.
 */
class Gyro
{
private:                            // private variables
    unsigned int m_channel;         // analog channel
    float m_reset_value;            // value during the last reset

public:
	Gyro(UINT32 slot, UINT32 channel);
	explicit Gyro(UINT32 channel);
	//explicit Gyro(AnalogChannel *channel);
	//explicit Gyro(AnalogChannel &channel);
	virtual ~Gyro();
	float GetAngle();
	void SetSensitivity(float voltsPerDegreePerSecond);
	void Reset();

private:
	void InitGyro();
};
#endif
