/*********************************************************************
*
*   HEADER NAME:
*       rob_pub.h - Robot publics
*
*   COPYRIGHT:
*       Software source code by Alex Morozov and Chris D. Locke is
*       licensed under a Creative Commons Attribution-Noncommercial-
*       Share Alike 3.0 United States License
*       (http://creativecommons.org/licenses/by-nc-sa/3.0/us/)
*
*********************************************************************/
#pragma once

typedef enum
    {
    ROB_MODE_DISABLED,
    ROB_MODE_AUTO,
    ROB_MODE_TELEOP
    } rob_mode_type;

void rob_get_pos
    (
    float *             hdg,
    float *             x,
    float *             y
    );

void rob_get_motors
    (
    int *               rt,
    int *               lt
    );
    
void rob_init
    ( void );

void rob_set_mode
    (
    rob_mode_type       mode
    );