/*
 *  SimRotator.h
 *  CppBot
 *
 *  Created by Alex on 2/1/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */
#pragma once

#include "SimInterface.h"
#include "SimObject.h"

/**************************************************************************
* SimRotator - a dimensionless object rotating around one axis
**************************************************************************/
class SimRotator : public SimObject
{
	enum { ENCODER_GAIN = 123 };

public:
    /**************************************************************************
    * SimRotator - Constructor
    **************************************************************************/
    SimRotator
        ( 
        unsigned int pwm_channel,   // PWM channel index (0 to SimInterface::PWM_CNT)
        unsigned int analog_channel,// analog sensor channel
        float max_rpm = 60,         // Maximum rotation rate (revolutions per minute)
        float zero_to_max_s = 0.001,// how many seconds it takes to go from zero to full speed
        float init_pos_deg = 0      // Initial position (degrees, measured counterclockwise from the X-axis)
        );

    /**************************************************************************
    * Get current hand position
    **************************************************************************/
    float GetAngle( void ) const { return( ( float )m_angle_deg ); };

    /**************************************************************************
    * Get current motor setting
    **************************************************************************/
    float GetMotorSetting( void ) const { return SimInterface::GetPWM( m_channel ); };
    int GetEncoderValue( void ) const { return SimInterface::GetEncoder( m_channel ); };    // HACK: encoder channel must match the motor channel

    /**************************************************************************
    * Update - Periodic update function
    **************************************************************************/
    virtual void Update
        ( 
        unsigned int update_rate_ms // update rate in milliseconds
        );

protected:
    /*
     * Returns current PWM setting
     */
    virtual double get_pwm( void )
    {
        return( SimInterface::GetPWM( m_channel ) );
    }

    /*
     * limit
     * Limit the specified angle value to the allowed range and return the 
     * result
     */
    virtual double limit( double angle_deg );
    
private:
    unsigned int m_channel;         // PWM channel index
    unsigned int m_analog_channel;  // analog sensor channel
    double m_max_rate_dps;          // Maximum rate of rotation in degrees/sec
    double m_rate_dps;              // Current rate of rotation in degrees/sec
    double m_angle_deg;             // Current position in degrees
    double m_drate_dt_dpss;         // maximum d(rate)/dt (degrees/sec^2)
};