/*
 *  GLUTWindow.h
 *  CppBot
 *
 *  Created by Alex on 1/31/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */
 
#pragma once
 
#include <stdlib.h>
#include "GLUT/glut.h"

/**************************************************************************
* GLUTWindow class reperesents a generic GLUT window
**************************************************************************/
class GLUTWindow
{
friend class GLUTInterface;

public:
    GLUTWindow( const char * name, int w, int h, int x, int y );

    virtual void DisplayCallBack( void ) = 0;
    void DrawText( float x, float y, char *c );
    virtual void ReshapeCallBack( int x, int y );
    
protected:
    enum                            // Protected class constants
        {
        TEXT_HEIGHT = 15
        };

    int window_w;                   /* current window width                 */
    int window_h;                   /* current window height                */
    int window_x;
    int window_y;
    int glut_id;                    /* GLUT window ID                       */

private:
    GLuint texture[ 1 ];            /* storage for textures                 */
};