/*
 *  GLUTRotator.cpp
 *  CppBot
 *
 *  Created by Alex on 2/1/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */

#include "GLUTRotatorWindow.h"

GLUTRotatorWindow::GLUTRotatorWindow( const char * name, const SimRotator * p_sim, int x, int y ) :
    GLUTWindow( name, 200, 200, x, y ),
    m_p_sim( p_sim )
{
}

void GLUTRotatorWindow::DisplayCallBack( void )
{
float x_center = window_w / 2;
float y_center = window_h / 2;

/*----------------------------------------------------------
Clear screen
----------------------------------------------------------*/
glClear( GL_COLOR_BUFFER_BIT );

/*----------------------------------------------------------
Load identity matrix
----------------------------------------------------------*/
glMatrixMode( GL_MODELVIEW );
glLoadIdentity();

//Print motor value
char buf[ 100 ];
float motor = m_p_sim->GetMotorSetting( );
_snprintf( buf, sizeof( buf ), "PWM: %f", motor );
DrawText( 5, 5, buf );
_snprintf( buf, sizeof( buf ), "ENC: %d", m_p_sim->GetEncoderValue() );
DrawText( 5, 15, buf );

//Draw rotating bar
float angle_deg = m_p_sim->GetAngle( );
glPushMatrix( );
    glTranslatef( x_center, y_center, 0.0f );
    glRotatef( angle_deg, 0.0f, 0.0f, 1.0f );

    glLineWidth( 3.0f );
    glBegin( GL_LINES );
        glColor3f( 0.0f, 1.0f, 0.0f );
        glVertex2f( 0.0f, 0.0f );
        glVertex2f( 0.0f, y_center - 10.0f );
    glEnd();
glPopMatrix( );

/*----------------------------------------------------------
Swap buffers to update display
----------------------------------------------------------*/
glutSwapBuffers();
}
