/*
 *  GLUTFieldWindow.h
 *  CppBot
 *
 *  Created by Alex on 1/31/10.
 *  Copyright 2010 __MyCompanyName__. All rights reserved.
 *
 */
 
 #include "GLUTWindow.h"
 
/**************************************************************************
* GLUTFieldWindow draws and maintains the picture of the field with the 
* robot on it.
**************************************************************************/
class GLUTFieldWindow : public GLUTWindow
{
private:
    enum
    {
        WIDTH = 600,
        HEIGHT = 600,
        JOY_BOX_RADIUS      = 25,
        JOY_BOX_CENTER_X    = WIDTH / 2,
        JOY_BOX_CENTER_Y    = HEIGHT - JOY_BOX_RADIUS,
        CROSS_HAIR_RADIUS   = JOY_BOX_RADIUS / 2,
        MOTOR_BAR_HEIGHT    = HEIGHT / 2 - 10,
        MOTOR_BAR_LEFT      = 25,
        MOTOR_BAR_RIGHT     = WIDTH - 25
    };

private:
    static int m_joy_x;             // joystick position
    static int m_joy_y;             // joystick position

public:
    GLUTFieldWindow( int x, int y ) : GLUTWindow( "Field", 600, 600, x, y ) 
    { 
        glutMouseFunc( mouse_cb );
        glutMotionFunc( motion_cb );
    }
    
    virtual void DisplayCallBack( void );
    virtual void ReshapeCallBack( int x, int y );
    
private:
    void draw_motor_bar( int motor_val, int motor_bar_x );
    static void motion_cb( int x, int y );
    static void mouse_cb( int button, int state, int x, int y );    
};

