/*********************************************************************
*
*   CppBot.cpp - C++ Robot simulator
*
*   Copyright:
*       Software source code by Alex Morozov and Chris D. Locke is
*       licensed under a Creative Commons Attribution-Noncommercial-
*       Share Alike 3.0 United States License
*       (http://creativecommons.org/licenses/by-nc-sa/3.0/us/)
*
*********************************************************************/

#include <stdlib.h>

#include "RobotParameter.h"

#include "GLUT/glut.h"
#include "GLUTDebugWindow.h"
#include "GLUTFieldWindow.h"
#include "GLUTInterface.h"
#include "GLUTRotatorWindow.h"

#include "SimLimitedRotator.h"
#include "SimRotator.h"
#include "SimWinchLift.h"

/*********************************************************************
* main - Main function
*********************************************************************/
int main(int argc, char* argv[])
{
/*----------------------------------------------------------
Instantiate GLUT windows
----------------------------------------------------------*/
GLUTInterface::Init( 50 , argc, argv );

// Create simulator objects
//SimLimitedRotator lift( 180.0f, 
//                         LIFT_MOTOR_CHANNEL, 
//                         LIFT_LO_SWITCH, 
//                         LIFT_HI_SWITCH );
SimWinchLift lift( LIFT_MOTOR_CHANNEL, 5 );
SimLimitedRotator arm( 180.0f, 
                         ARM_1_MOTOR_CHANNEL,
                         ARM_GYRO_CHANNEL,
                         ARM_1_LO_SWITCH, 
                         ARM_1_HI_SWITCH );

// Create windows
GLUTFieldWindow field_window( 50, 50 );
GLUTRotatorWindow arm_2_window( "Arm 2", &lift, 660, 50 );	// This really is a lift, but we'll call it an arm so that we don't have too change the seminar handouts
GLUTRotatorWindow arm_1_window( "Arm 1", &arm, 660, 50 + 250 );
GLUTDebugWindow debug_window( 870, 50 );

/*----------------------------------------------------------
Run main program
----------------------------------------------------------*/
glutMainLoop();

return( 0 );
}
