/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import com.ni.rio.NiRioStatus;
import com.sun.cldc.jna.ptr.IntByReference;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tInterruptManager
extends tSystem {
    private static final int kFPGA_INTERRUPT_BASE_ADDRESS = 32768;
    private static final int kFPGA_INTERRUPT_ACKNOWLEDGE_ADDRESS = 32780;
    private int m_interruptMask;
    private IntByReference m_rioContext;
    private boolean m_watcher;
    private boolean m_enabled;
    private static int m_globalInterruptMask = 0;

    public tInterruptManager(int interruptMask, boolean watcher) {
        if (status.isFatal()) {
            return;
        }
        this.m_interruptMask = interruptMask;
        this.m_rioContext = new IntByReference(0);
        this.m_watcher = watcher;
        this.m_enabled = false;
        NiRioSrv.irqReserve(m_DeviceHandle, this.m_rioContext, status);
    }

    protected void finalize() {
        NiRioStatus tempStatus = new NiRioStatus();
        NiRioSrv.irqUnreserve(m_DeviceHandle, this.m_rioContext, tempStatus);
        super.finalize();
    }

    public int watch(int timeoutInMs) {
        if (!this.m_watcher) {
            status.setStatus(-50001);
            return 0;
        }
        this.reserve();
        if (status.isFatal()) {
            return 0;
        }
        this.acknowledge();
        int intsAsserted = NiRioSrv.irqWait(m_DeviceHandle, this.m_rioContext, this.m_interruptMask, timeoutInMs, status);
        this.acknowledge();
        this.unreserve();
        return intsAsserted;
    }

    protected void acknowledge() {
        NiRioSrv.poke32(m_DeviceHandle, 32780, this.m_interruptMask, status);
    }

    protected void reserve() {
        if ((m_globalInterruptMask & this.m_interruptMask) != 0 || this.m_enabled) {
            status.setStatus(-63071);
        } else {
            m_globalInterruptMask |= this.m_interruptMask;
            this.m_enabled = true;
        }
    }

    protected void unreserve() {
        if (!this.m_enabled) {
            status.setStatus(-63072);
        } else {
            this.m_enabled = false;
            m_globalInterruptMask &= ~this.m_interruptMask;
        }
    }
}

