/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tAI
extends tSystem {
    public static final int kNumSystems = 2;
    public final int m_SystemIndex;
    private static final int kConfig_ScanSize_BitfieldMask = 0x1C000000;
    private static final int kConfig_ScanSize_BitfieldOffset = 26;
    private static final int kConfig_ConvertRate_BitfieldMask = 0x3FFFFFF;
    private static final int kConfig_ConvertRate_BitfieldOffset = 0;
    private static final int kAI0_Config_Address = 33792;
    private static final int kAI1_Config_Address = 33772;
    private static final int[] kConfig_Addresses = new int[]{33792, 33772};
    public static final int kScanList_NumElements = 8;
    public static final int kScanList_ElementSize = 3;
    public static final int kScanList_ElementMask = 7;
    private static final int kAI0_ScanList_Address = 33788;
    private static final int kAI1_ScanList_Address = 33768;
    private static final int[] kScanList_Addresses = new int[]{33788, 33768};
    public static final int kAverageBits_NumElements = 8;
    public static final int kAverageBits_ElementSize = 4;
    public static final int kAverageBits_ElementMask = 15;
    private static final int kAI0_AverageBits_Address = 33780;
    private static final int kAI1_AverageBits_Address = 33760;
    private static final int[] kAverageBits_Addresses = new int[]{33780, 33760};
    private static final int kAI0_LoopTiming_Address = 33776;
    private static final int kAI1_LoopTiming_Address = 33756;
    private static final int[] kLoopTiming_Addresses = new int[]{33776, 33756};
    public static final int kOversampleBits_NumElements = 8;
    public static final int kOversampleBits_ElementSize = 4;
    public static final int kOversampleBits_ElementMask = 15;
    private static final int kAI0_OversampleBits_Address = 33784;
    private static final int kAI1_OversampleBits_Address = 33764;
    private static final int[] kOversampleBits_Addresses = new int[]{33784, 33764};
    private static final int kAI_Output_Address = 33796;
    private static final int kReadSelect_Channel_BitfieldMask = 28;
    private static final int kReadSelect_Channel_BitfieldOffset = 2;
    private static final int kReadSelect_Module_BitfieldMask = 2;
    private static final int kReadSelect_Module_BitfieldOffset = 1;
    private static final int kReadSelect_Averaged_BitfieldMask = 1;
    private static final int kReadSelect_Averaged_BitfieldOffset = 0;
    private static final int kAI_ReadSelect_Address = 33804;
    private static final int kAI_LatchOutput_Address = 33800;

    public tAI(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 2) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public void writeConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeConfig_ScanSize(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xE3FFFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 26 & 0x1C000000, status);
    }

    public void writeConfig_ConvertRate(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFC000000;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 0 & 0x3FFFFFF, status);
    }

    public int readConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readConfig_ScanSize() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1C000000) >>> 26;
        return (byte)(bitfieldValue & 7);
    }

    public int readConfig_ConvertRate() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x3FFFFFF) >>> 0;
        return bitfieldValue & 0x3FFFFFF;
    }

    public void writeScanList(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kScanList_Addresses[this.m_SystemIndex], status);
        regValue &= ~(7 << (7 - bitfield_index) * 3);
        NiRioSrv.poke32(m_DeviceHandle, kScanList_Addresses[this.m_SystemIndex], regValue |= (value & 7) << (7 - bitfield_index) * 3, status);
    }

    public byte readScanList(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kScanList_Addresses[this.m_SystemIndex], status) >>> (7 - bitfield_index) * 3 & 7;
        return (byte)(arrayElementValue & 7);
    }

    public void writeAverageBits(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kAverageBits_Addresses[this.m_SystemIndex], status);
        regValue &= ~(15 << (7 - bitfield_index) * 4);
        NiRioSrv.poke32(m_DeviceHandle, kAverageBits_Addresses[this.m_SystemIndex], regValue |= (value & 0xF) << (7 - bitfield_index) * 4, status);
    }

    public byte readAverageBits(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kAverageBits_Addresses[this.m_SystemIndex], status) >>> (7 - bitfield_index) * 4 & 0xF;
        return (byte)(arrayElementValue & 0xF);
    }

    public long readLoopTiming() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kLoopTiming_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public void writeOversampleBits(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kOversampleBits_Addresses[this.m_SystemIndex], status);
        regValue &= ~(15 << (7 - bitfield_index) * 4);
        NiRioSrv.poke32(m_DeviceHandle, kOversampleBits_Addresses[this.m_SystemIndex], regValue |= (value & 0xF) << (7 - bitfield_index) * 4, status);
    }

    public byte readOversampleBits(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 8) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kOversampleBits_Addresses[this.m_SystemIndex], status) >>> (7 - bitfield_index) * 4 & 0xF;
        return (byte)(arrayElementValue & 0xF);
    }

    public static int readOutput() {
        return NiRioSrv.peek32(m_DeviceHandle, 33796, status);
    }

    public static void writeReadSelect(int value) {
        NiRioSrv.poke32(m_DeviceHandle, 33804, value, status);
    }

    public static void writeReadSelect_Channel(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        regValue &= 0xFFFFFFE3;
        NiRioSrv.poke32(m_DeviceHandle, 33804, regValue |= value << 2 & 0x1C, status);
    }

    public static void writeReadSelect_Module(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        regValue &= 0xFFFFFFFD;
        NiRioSrv.poke32(m_DeviceHandle, 33804, regValue |= value << 1 & 2, status);
    }

    public static void writeReadSelect_Averaged(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        regValue &= 0xFFFFFFFE;
        NiRioSrv.poke32(m_DeviceHandle, 33804, regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public static int readReadSelect() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        return regValue;
    }

    public static byte readReadSelect_Channel() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        int bitfieldValue = (regValue & 0x1C) >>> 2;
        return (byte)(bitfieldValue & 7);
    }

    public static byte readReadSelect_Module() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        int bitfieldValue = (regValue & 2) >>> 1;
        return (byte)(bitfieldValue & 1);
    }

    public static boolean readReadSelect_Averaged() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33804, status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public static void strobeLatchOutput() {
        NiRioSrv.poke32(m_DeviceHandle, 33800, 1, status);
    }
}

