/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.communication;

import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.squawk.platform.posix.LibCUtil;
import edu.wpi.first.wpilibj.communication.SemaphoreException;

public class Semaphore {
    Pointer m_semaphore;
    static final int SEM_Q_FIFO = 0;
    static final int SEM_Q_PRIORITY = 1;
    static final int SEM_DELETE_SAFE = 4;
    static final int SEM_INVERSION_SAFE = 8;
    static final int SEM_EVENTSEND_ERR_NOTIFY = 16;
    static final int SEM_INTERRUPTIBLE = 32;
    private static Function semMCreateFn = NativeLibrary.getDefaultInstance().getFunction("semMCreate");
    private static Function semBCreateFn = NativeLibrary.getDefaultInstance().getFunction("semBCreate");
    private static Function semCCreateFn = NativeLibrary.getDefaultInstance().getFunction("semCCreate");
    private static Function semDeleteFn = NativeLibrary.getDefaultInstance().getFunction("semDelete");
    private static Function semFlushFn = NativeLibrary.getDefaultInstance().getFunction("semFlush");
    private static Function semGiveFn = NativeLibrary.getDefaultInstance().getFunction("semGive");
    private static Function semTakeFn = NativeLibrary.getDefaultInstance().getFunction("semTake");
    private static Function semCloseFn = NativeLibrary.getDefaultInstance().getFunction("semClose");

    private void checkStatus(int status) throws SemaphoreException {
        if (status != 0) {
            throw new SemaphoreException(LibCUtil.errno());
        }
    }

    public Semaphore(Options options) {
        this.m_semaphore = new Pointer((long)semMCreateFn.call1(options.value), 0);
    }

    public Semaphore(Options options, boolean initialState) {
        this.m_semaphore = new Pointer((long)semBCreateFn.call2(options.value, initialState ? 1 : 0), 0);
    }

    public Semaphore(Options options, int count) {
        this.m_semaphore = new Pointer((long)semCCreateFn.call2(options.value, count), 0);
    }

    public void flush() throws SemaphoreException {
        this.checkStatus(semFlushFn.call1(this.m_semaphore));
    }

    public void give() throws SemaphoreException {
        this.checkStatus(semGiveFn.call1(this.m_semaphore));
    }

    public void take(double timeout) throws SemaphoreException {
        this.checkStatus(semTakeFn.call2(this.m_semaphore, (int)(timeout * 1000.0)));
    }

    public boolean tryTake() throws SemaphoreException {
        int result = semTakeFn.call2(this.m_semaphore, 0);
        if (result == 0) {
            return true;
        }
        int errno = LibCUtil.errno();
        if (errno == 3997698) {
            return false;
        }
        throw new SemaphoreException(errno);
    }

    public void close() throws SemaphoreException {
        this.checkStatus(semCloseFn.call1(this.m_semaphore));
    }

    public void free() throws SemaphoreException {
        this.checkStatus(semDeleteFn.call1(this.m_semaphore));
    }

    public static class Options {
        int value = 0;

        public void setPrioritySorted(boolean priority) {
            this.value = priority ? (this.value |= 1) : (this.value &= 0xFFFFFFFE);
        }

        public void setDeleteSafe(boolean delSafe) {
            this.value = delSafe ? (this.value |= 4) : (this.value &= 0xFFFFFFFB);
        }

        public void setInversionSafe(boolean invSafe) {
            this.value = invSafe ? (this.value |= 8) : (this.value &= 0xFFFFFFF7);
        }

        public void setErrorNotify(boolean errNot) {
            this.value = errNot ? (this.value |= 0x10) : (this.value &= 0xFFFFFFEF);
        }

        public void setInterruptable(boolean intable) {
            this.value = intable ? (this.value |= 0x20) : (this.value &= 0xFFFFFFDF);
        }
    }
}

