/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Relay
extends SensorBase {
    private int m_channel;
    private Direction m_direction;
    private DigitalModule m_module;
    private static Resource relayChannels = new Resource(16);

    private void initRelay(int slot) {
        SensorBase.checkRelayModule(slot);
        SensorBase.checkRelayChannel(this.m_channel);
        try {
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                relayChannels.allocate((DigitalModule.slotToIndex(slot) * 8 + this.m_channel - 1) * 2);
            }
            if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
                relayChannels.allocate((DigitalModule.slotToIndex(slot) * 8 + this.m_channel - 1) * 2 + 1);
            }
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Relay channel " + this.m_channel + " on module " + slot + " is already allocated");
        }
        this.m_module = DigitalModule.getInstance(slot);
        this.m_module.setRelayForward(this.m_channel, false);
        this.m_module.setRelayReverse(this.m_channel, false);
    }

    public Relay(int slot, int channel, Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        this.m_channel = channel;
        this.m_direction = direction;
        this.initRelay(slot);
    }

    public Relay(int channel, Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        this.m_channel = channel;
        this.m_direction = direction;
        this.initRelay(Relay.getDefaultDigitalModule());
    }

    public Relay(int slot, int channel) {
        this.m_channel = channel;
        this.m_direction = Direction.kBoth;
        this.initRelay(slot);
    }

    public Relay(int channel) {
        this.m_channel = channel;
        this.m_direction = Direction.kBoth;
        this.initRelay(Relay.getDefaultDigitalModule());
    }

    protected void free() {
        this.m_module.setRelayForward(this.m_channel, false);
        this.m_module.setRelayReverse(this.m_channel, false);
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
            relayChannels.free((DigitalModule.slotToIndex(this.m_module.getSlot()) * 8 + this.m_channel - 1) * 2);
        }
        if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kReverse) {
            relayChannels.free((DigitalModule.slotToIndex(this.m_module.getSlot()) * 8 + this.m_channel - 1) * 2 + 1);
        }
    }

    public void set(Value value) {
        switch (value.value) {
            case 0: {
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, false);
                break;
            }
            case 1: {
                if (this.m_direction == Direction.kBoth) {
                    throw new InvalidValueException("A relay configured to both directions cannot be set to on");
                }
                if (this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, true);
                    break;
                }
                if (this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, true);
                break;
            }
            case 2: {
                if (this.m_direction == Direction.kReverse) {
                    throw new InvalidValueException("A relay configured for reverse cannot be set to forward");
                }
                if (this.m_direction == Direction.kBoth || this.m_direction == Direction.kForward) {
                    this.m_module.setRelayForward(this.m_channel, true);
                }
                if (this.m_direction != Direction.kBoth) break;
                this.m_module.setRelayReverse(this.m_channel, false);
                break;
            }
            case 3: {
                if (this.m_direction == Direction.kForward) {
                    throw new InvalidValueException("A relay configured for forward cannot be set to reverse");
                }
                if (this.m_direction == Direction.kBoth) {
                    this.m_module.setRelayForward(this.m_channel, false);
                }
                if (this.m_direction != Direction.kBoth && this.m_direction != Direction.kReverse) break;
                this.m_module.setRelayReverse(this.m_channel, true);
                break;
            }
        }
    }

    public void setDirection(Direction direction) {
        if (direction == null) {
            throw new NullPointerException("Null Direction was given");
        }
        if (this.m_direction == direction) {
            return;
        }
        this.free();
        this.m_direction = direction;
        this.initRelay(this.m_module.getSlot());
    }

    public static class Direction {
        public final int value;
        static final int kBoth_val = 0;
        static final int kForward_val = 1;
        static final int kReverse_val = 2;
        public static final Direction kBoth = new Direction(0);
        public static final Direction kForward = new Direction(1);
        public static final Direction kReverse = new Direction(2);

        private Direction(int value) {
            this.value = value;
        }
    }

    public static class Value {
        public final int value;
        static final int kOff_val = 0;
        static final int kOn_val = 1;
        static final int kForward_val = 2;
        static final int kReverse_val = 3;
        public static final Value kOff = new Value(0);
        public static final Value kOn = new Value(1);
        public static final Value kForward = new Value(2);
        public static final Value kReverse = new Value(3);

        private Value(int value) {
            this.value = value;
        }
    }

    public class InvalidValueException
    extends RuntimeException {
        public InvalidValueException(String message) {
            super(message);
        }
    }
}

