/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.DigitalModule;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class PWM
extends SensorBase {
    private static Resource allocated = new Resource(20);
    private int m_channel;
    private DigitalModule m_module;
    protected static final int kDefaultPwmPeriod = 774;
    protected static final int kDefaultMinPwmHigh = 102;
    static final int kPwmDisabled = 0;
    boolean m_eliminateDeadband;
    int m_maxPwm;
    int m_deadbandMaxPwm;
    int m_centerPwm;
    int m_deadbandMinPwm;
    int m_minPwm;

    private void initPWM(int slot, int channel) {
        PWM.checkPWMModule(slot);
        PWM.checkPWMChannel(channel);
        try {
            allocated.allocate(DigitalModule.slotToIndex(slot) * 10 + channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("PWM channel " + channel + " on module " + slot + " is already allocated");
        }
        this.m_channel = channel;
        this.m_module = DigitalModule.getInstance(slot);
        this.m_module.setPWM(this.m_channel, 0);
        this.m_eliminateDeadband = false;
    }

    public PWM(int slot, int channel) {
        this.initPWM(slot, channel);
    }

    public PWM(int channel) {
        this.initPWM(PWM.getDefaultDigitalModule(), channel);
    }

    protected void free() {
        this.m_module.setPWM(this.m_channel, 0);
        allocated.free(DigitalModule.slotToIndex(this.m_module.getSlot()) * 10 + this.m_channel - 1);
    }

    public void enableDeadbandElimination(boolean eliminateDeadband) {
        this.m_eliminateDeadband = eliminateDeadband;
    }

    public void setBounds(int max, int deadbandMax, int center, int deadbandMin, int min) {
        this.m_maxPwm = max;
        this.m_deadbandMaxPwm = deadbandMax;
        this.m_centerPwm = center;
        this.m_deadbandMinPwm = deadbandMin;
        this.m_minPwm = min;
    }

    public void setPosition(double pos) {
        if (pos < 0.0) {
            pos = 0.0;
        } else if (pos > 1.0) {
            pos = 1.0;
        }
        int rawValue = (int)(pos * (double)this.getFullRangeScaleFactor() + (double)this.getMinNegativePwm());
        this.setRaw(rawValue);
    }

    public double getPosition() {
        int value = this.getRaw();
        if (value < this.getMinNegativePwm()) {
            return 0.0;
        }
        if (value > this.getMaxPositivePwm()) {
            return 1.0;
        }
        return (value - this.getMinNegativePwm()) / this.getFullRangeScaleFactor();
    }

    final void setSpeed(double speed) {
        if (speed < -1.0) {
            speed = -1.0;
        } else if (speed > 1.0) {
            speed = 1.0;
        }
        int rawValue = speed == 0.0 ? this.getCenterPwm() : (speed > 0.0 ? (int)(speed * (double)this.getPositiveScaleFactor() + (double)this.getMinPositivePwm() + 0.5) : (int)(speed * (double)this.getNegativeScaleFactor() + (double)this.getMaxNegativePwm() + 0.5));
        this.setRaw(rawValue);
    }

    public double getSpeed() {
        int value = this.getRaw();
        if (value > this.getMaxPositivePwm()) {
            return 1.0;
        }
        if (value < this.getMinNegativePwm()) {
            return -1.0;
        }
        if (value > this.getMinPositivePwm()) {
            return (double)(value - this.getMinPositivePwm()) / (double)this.getPositiveScaleFactor();
        }
        if (value < this.getMaxNegativePwm()) {
            return (double)(value - this.getMaxNegativePwm()) / (double)this.getNegativeScaleFactor();
        }
        return 0.0;
    }

    public void setRaw(int value) {
        this.m_module.setPWM(this.m_channel, value);
    }

    public int getRaw() {
        return this.m_module.getPWM(this.m_channel);
    }

    public void setPeriodMultiplier(PeriodMultiplier mult) {
        switch (mult.value) {
            case 4: {
                this.m_module.setPWMPeriodScale(this.m_channel, 3);
                break;
            }
            case 2: {
                this.m_module.setPWMPeriodScale(this.m_channel, 1);
                break;
            }
            case 1: {
                this.m_module.setPWMPeriodScale(this.m_channel, 0);
                break;
            }
        }
    }

    private int getMaxPositivePwm() {
        return this.m_maxPwm;
    }

    private int getMinPositivePwm() {
        return this.m_eliminateDeadband ? this.m_deadbandMaxPwm : this.m_centerPwm + 1;
    }

    private int getCenterPwm() {
        return this.m_centerPwm;
    }

    private int getMaxNegativePwm() {
        return this.m_eliminateDeadband ? this.m_deadbandMinPwm : this.m_centerPwm - 1;
    }

    private int getMinNegativePwm() {
        return this.m_minPwm;
    }

    private int getPositiveScaleFactor() {
        return this.getMaxPositivePwm() - this.getMinPositivePwm();
    }

    private int getNegativeScaleFactor() {
        return this.getMaxNegativePwm() - this.getMinNegativePwm();
    }

    private int getFullRangeScaleFactor() {
        return this.getMaxPositivePwm() - this.getMinNegativePwm();
    }

    public static class PeriodMultiplier {
        public final int value;
        static final int k1X_val = 1;
        static final int k2X_val = 2;
        static final int k4X_val = 4;
        public static final PeriodMultiplier k1X = new PeriodMultiplier(1);
        public static final PeriodMultiplier k2X = new PeriodMultiplier(2);
        public static final PeriodMultiplier k4X = new PeriodMultiplier(4);

        private PeriodMultiplier(int value) {
            this.value = value;
        }
    }
}

