/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.RobotBase;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.communication.Semaphore;
import edu.wpi.first.wpilibj.communication.SemaphoreException;

public class IterativeRobot
extends RobotBase {
    private static final boolean TRACE_LOOP_ALLOCATIONS = false;
    private static final boolean TRACE_LOOP_ALLOCATIONS_AFTER_INIT = true;
    public static final double kDefaultPeriod = 0.02;
    private boolean m_disabledInitialized;
    private boolean m_autonomousInitialized;
    private boolean m_teleopInitialized;
    private long m_disabledLoops;
    private long m_autonomousLoops;
    private long m_teleopLoops;
    private Timer m_mainLoopTimer;
    private long m_count;
    private Semaphore m_packetDataAvailableSem;

    public IterativeRobot() {
        System.out.println("IterativeRobot Constructor Start");
        this.m_disabledInitialized = false;
        this.m_autonomousInitialized = false;
        this.m_teleopInitialized = false;
        this.m_disabledLoops = 0L;
        this.m_autonomousLoops = 0L;
        this.m_teleopLoops = 0L;
        this.m_count = 0L;
        this.m_mainLoopTimer = new Timer();
        this.m_mainLoopTimer.start();
        Semaphore.Options options = new Semaphore.Options();
        options.setPrioritySorted(true);
        this.m_packetDataAvailableSem = new Semaphore(options, false);
        FRCControl.setNewDataSem(this.m_packetDataAvailableSem);
        System.out.println("IterativeRobot Constructor Finish");
    }

    public void startCompetition() {
        System.out.println("IterativeRobot startCompetition() Start");
        this.robotInit();
        int TRACE_LOOP_MAX = 100;
        int loopCount = 100;
        Object marker = null;
        boolean didDisabledPeriodic = false;
        boolean didAutonomousPeriodic = false;
        boolean didTeleopPeriodic = false;
        while (true) {
            if (this.isDisabled()) {
                if (!this.m_disabledInitialized) {
                    this.disabledInit();
                    this.m_disabledInitialized = true;
                    this.m_autonomousInitialized = false;
                    this.m_teleopInitialized = false;
                    System.out.println("Disabled_Init() completed");
                }
                if (this.nextPeriodReady()) {
                    this.disabledPeriodic();
                    didDisabledPeriodic = true;
                }
                this.disabledContinuous();
                continue;
            }
            if (this.isAutonomous()) {
                if (!this.m_autonomousInitialized) {
                    this.autonomousInit();
                    this.m_autonomousInitialized = true;
                    this.m_teleopInitialized = false;
                    this.m_disabledInitialized = false;
                    System.out.println("Autonomous_Init() completed");
                }
                if (this.nextPeriodReady()) {
                    this.getWatchdog().feed();
                    this.autonomousPeriodic();
                    didAutonomousPeriodic = true;
                }
                this.autonomousContinuous();
                continue;
            }
            if (!this.m_teleopInitialized) {
                this.teleopInit();
                this.m_teleopInitialized = true;
                this.m_autonomousInitialized = false;
                this.m_disabledInitialized = false;
                System.out.println("Teleop_Init() completed");
            }
            if (this.nextPeriodReady()) {
                this.getWatchdog().feed();
                this.teleopPeriodic();
                didTeleopPeriodic = true;
            }
            this.teleopContinuous();
        }
    }

    private boolean nextPeriodReady() {
        ++this.m_count;
        try {
            if (this.m_packetDataAvailableSem.tryTake()) {
                double curTime = this.m_mainLoopTimer.get();
                this.m_mainLoopTimer.reset();
                this.m_count = 0L;
                return true;
            }
            return false;
        }
        catch (SemaphoreException e) {
            return false;
        }
    }

    public void robotInit() {
        System.out.println("Default RobotIterativeBase::RobotInit() method running");
    }

    public void disabledInit() {
        System.out.println("Default RobotIterativeBase::DisabledInit() method running");
    }

    public void autonomousInit() {
        System.out.println("Default RobotIterativeBase::AutonomousInit() method running");
    }

    public void teleopInit() {
        System.out.println("Default RobotIterativeBase::TeleopInit() method running");
    }

    public void disabledPeriodic() {
        System.out.print("D - ");
        System.out.println(this.m_disabledLoops);
        this.m_disabledLoops = 0L;
    }

    public void autonomousPeriodic() {
        System.out.print("A - ");
        System.out.println(this.m_autonomousLoops);
        this.m_autonomousLoops = 0L;
    }

    public void teleopPeriodic() {
        System.out.print("T - ");
        System.out.println(this.m_teleopLoops);
        this.m_teleopLoops = 0L;
    }

    public void disabledContinuous() {
        ++this.m_disabledLoops;
    }

    public void autonomousContinuous() {
        ++this.m_autonomousLoops;
    }

    public void teleopContinuous() {
        ++this.m_teleopLoops;
    }
}

