/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import edu.wpi.first.wpilibj.communication.FRCControl;
import edu.wpi.first.wpilibj.util.BoundaryException;

public class DriverStationEnhancedIO {
    public static final double kAnalogInputResolution = 16383.0;
    public static final double kAnalogInputReference = 3.3;
    public static final double kAnalogOutputResolution = 255.0;
    public static final double kAnalogOutputReference = 4.0;
    public static final double kAccelOffset = 8300.0;
    public static final double kAccelScale = 3300.0;
    public static final int kSupportedAPIVersion = 1;
    control_block_t m_inputData;
    status_block_t m_outputData;
    final Object m_inputDataSemaphore;
    final Object m_outputDataSemaphore;
    boolean m_inputValid = false;
    boolean m_outputValid = false;
    boolean m_configChanged = false;
    boolean m_requestEnhancedEnable = false;
    short[] m_encoderOffsets = new short[2];
    static final byte kInputBlockID = 17;
    static final byte kOutputBlockID = 18;
    static final int kStatusValid = 1;
    static final int kStatusConfigChanged = 2;
    static final int kForceEnhancedMode = 4;
    status_block_t tempOutputData = new status_block_t();
    control_block_t tempInputData = new control_block_t();

    DriverStationEnhancedIO() {
        this.m_inputData = new control_block_t();
        this.m_outputData = new status_block_t();
        this.m_outputData.size = (byte)(this.m_outputData.size() - 1);
        this.m_outputData.id = (byte)18;
        this.m_outputData.data.fixed_digital_out = (byte)3;
        this.m_inputDataSemaphore = new Object();
        this.m_outputDataSemaphore = new Object();
        this.m_encoderOffsets[0] = 0;
        this.m_encoderOffsets[1] = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateData() {
        int retVal;
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            if (this.m_outputValid || this.m_configChanged || this.m_requestEnhancedEnable) {
                this.m_outputData.flags = 1;
                if (this.m_requestEnhancedEnable) {
                    this.m_outputData.flags = (byte)(this.m_outputData.flags | 4);
                }
                if (this.m_configChanged) {
                    if (!this.m_outputValid) {
                        this.m_outputData.flags = (byte)(this.m_outputData.flags | 4);
                    }
                    this.m_outputData.flags = (byte)(this.m_outputData.flags | 2);
                }
                FRCControl.overrideIOConfig(this.m_outputData, 5);
            }
            if ((retVal = FRCControl.getDynamicControlData((byte)18, this.tempOutputData, this.tempOutputData.size(), 5)) == 0) {
                if (this.m_outputValid) {
                    if (this.m_configChanged) {
                        if (this.isConfigEqual(this.tempOutputData, this.m_outputData)) {
                            this.m_configChanged = false;
                        }
                    } else {
                        this.mergeConfigIntoOutput(this.tempOutputData, this.m_outputData);
                    }
                } else {
                    this.mergeConfigIntoOutput(this.tempOutputData, this.m_outputData);
                }
                this.m_requestEnhancedEnable = false;
                this.m_outputValid = true;
            } else {
                this.m_outputValid = false;
                this.m_inputValid = false;
            }
        }
        object = this.m_inputDataSemaphore;
        synchronized (object) {
            retVal = FRCControl.getDynamicControlData((byte)17, this.tempInputData, this.tempInputData.size(), 5);
            if (retVal == 0 && this.tempInputData.data.api_version == 1) {
                this.tempInputData.copy(this.m_inputData);
                this.m_inputValid = true;
            } else {
                this.m_outputValid = false;
                this.m_inputValid = false;
            }
        }
    }

    void mergeConfigIntoOutput(status_block_t dsOutputBlock, status_block_t localCache) {
        localCache.data.digital = (short)(localCache.data.digital & dsOutputBlock.data.digital_oe | dsOutputBlock.data.digital & ~dsOutputBlock.data.digital_oe);
        localCache.data.digital_oe = dsOutputBlock.data.digital_oe;
        localCache.data.digital_pe = dsOutputBlock.data.digital_pe;
        localCache.data.pwm_period[0] = dsOutputBlock.data.pwm_period[0];
        localCache.data.pwm_period[1] = dsOutputBlock.data.pwm_period[1];
        localCache.data.setEnables(dsOutputBlock.data.getEnables());
    }

    boolean isConfigEqual(status_block_t dsOutputBlock, status_block_t localCache) {
        if (localCache.data.digital_oe != dsOutputBlock.data.digital_oe) {
            return false;
        }
        if ((localCache.data.digital & ~dsOutputBlock.data.digital) != (dsOutputBlock.data.digital & ~dsOutputBlock.data.digital)) {
            return false;
        }
        if (localCache.data.digital_pe != dsOutputBlock.data.digital_pe) {
            return false;
        }
        if (localCache.data.pwm_period[0] != dsOutputBlock.data.pwm_period[0]) {
            return false;
        }
        if (localCache.data.pwm_period[1] != dsOutputBlock.data.pwm_period[1]) {
            return false;
        }
        return localCache.data.getEnables() == dsOutputBlock.data.getEnables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAcceleration(tAccelChannel channel) throws EnhancedIOException {
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return ((double)this.m_inputData.data.accel[channel.value] - 8300.0) / 3300.0;
        }
    }

    public double getAnalogIn(int channel) throws EnhancedIOException {
        return this.getAnalogInRatio(channel) * 3.3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAnalogInRatio(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 8.0);
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return (double)this.m_inputData.data.analog[channel - 1] / 16383.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getAnalogOut(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 2.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            int tempData = this.m_outputData.data.dac[channel - 1];
            tempData = tempData < 0 ? tempData + 256 : tempData;
            return (double)tempData * 4.0 / 255.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAnalogOut(int channel, double value) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 2.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        if (value < 0.0) {
            value = 0.0;
        }
        if (value > 4.0) {
            value = 4.0;
        }
        if (value > 4.0) {
            value = 4.0;
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_outputData.data.dac[channel - 1] = (byte)(value / 4.0 * 255.0);
        }
    }

    public boolean getButton(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 6.0);
        return (this.getButtons() >> channel - 1 & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getButtons() throws EnhancedIOException {
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return this.m_inputData.data.buttons;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLED(int channel, boolean value) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 8.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            byte leds = this.m_outputData.data.leds;
            leds = (byte)(leds & ~(1 << channel - 1));
            if (value) {
                leds = (byte)(leds | 1 << channel - 1);
            }
            this.m_outputData.data.leds = leds;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLEDs(byte value) throws EnhancedIOException {
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_outputData.data.leds = value;
        }
    }

    public boolean getDigital(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 16.0);
        return (this.getDigitals() >> channel - 1 & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getDigitals() throws EnhancedIOException {
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return this.m_inputData.data.digital;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDigitalOutput(int channel, boolean value) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 16.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            if ((this.m_outputData.data.digital_oe & 1 << channel - 1) != 0) {
                short digital = this.m_outputData.data.digital;
                digital = (short)(digital & ~(1 << channel - 1));
                if (value) {
                    digital = (short)(digital | 1 << channel - 1);
                }
                this.m_outputData.data.digital = digital;
            } else {
                System.err.println("Line not configured for output");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public tDigitalConfig getDigitalConfig(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 16.0);
        if (!this.m_outputValid) {
            this.m_requestEnhancedEnable = true;
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            if (channel >= 1 && channel <= 4 && (this.m_outputData.data.pwm_enable & 1 << channel - 1) != 0) {
                return tDigitalConfig.kPWM;
            }
            if (channel >= 15 && channel <= 16 && (this.m_outputData.data.comparator_enable & 1 << channel - 15) != 0) {
                return tDigitalConfig.kAnalogComparator;
            }
            if ((this.m_outputData.data.digital_oe & 1 << channel - 1) != 0) {
                return tDigitalConfig.kOutput;
            }
            if ((this.m_outputData.data.digital_pe & 1 << channel - 1) == 0) {
                return tDigitalConfig.kInputFloating;
            }
            if ((this.m_outputData.data.digital & 1 << channel - 1) != 0) {
                return tDigitalConfig.kInputPullUp;
            }
            return tDigitalConfig.kInputPullDown;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDigitalConfig(int channel, tDigitalConfig config) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 16.0);
        if (config == tDigitalConfig.kPWM && (channel > 4 || channel < 1)) {
            throw new EnhancedIOException("PWM channels must be between 1 and 4");
        }
        if (config == tDigitalConfig.kAnalogComparator && (channel < 15 || channel > 16)) {
            throw new EnhancedIOException("Analog comparator channels must be between 15 and 16");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_configChanged = true;
            if (channel >= 1 && channel <= 4) {
                if (config == tDigitalConfig.kPWM) {
                    this.m_outputData.data.pwm_enable = (byte)(this.m_outputData.data.pwm_enable | 1 << channel - 1);
                    this.m_outputData.data.digital = (short)(this.m_outputData.data.digital & ~(1 << channel - 1));
                    this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe | 1 << channel - 1);
                    this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe & ~(1 << channel - 1));
                    return;
                }
                this.m_outputData.data.pwm_enable = (byte)(this.m_outputData.data.pwm_enable & ~(1 << channel - 1));
            } else if (channel >= 15 && channel <= 16) {
                if (config == tDigitalConfig.kAnalogComparator) {
                    this.m_outputData.data.comparator_enable = (byte)(this.m_outputData.data.comparator_enable | 1 << channel - 15);
                    this.m_outputData.data.digital = (short)(this.m_outputData.data.digital & ~(1 << channel - 1));
                    this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe & ~(1 << channel - 1));
                    this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe & ~(1 << channel - 1));
                    return;
                }
                this.m_outputData.data.comparator_enable = (byte)(this.m_outputData.data.comparator_enable & ~(1 << channel - 15));
            }
            if (config == tDigitalConfig.kInputFloating) {
                this.m_outputData.data.digital = (short)(this.m_outputData.data.digital & ~(1 << channel - 1));
                this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe & ~(1 << channel - 1));
                this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe & ~(1 << channel - 1));
            } else if (config == tDigitalConfig.kInputPullUp) {
                this.m_outputData.data.digital = (short)(this.m_outputData.data.digital | 1 << channel - 1);
                this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe & ~(1 << channel - 1));
                this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe | 1 << channel - 1);
            } else if (config == tDigitalConfig.kInputPullDown) {
                this.m_outputData.data.digital = (short)(this.m_outputData.data.digital & ~(1 << channel - 1));
                this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe & ~(1 << channel - 1));
                this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe | 1 << channel - 1);
            } else if (config == tDigitalConfig.kOutput) {
                this.m_outputData.data.digital_oe = (short)(this.m_outputData.data.digital_oe | 1 << channel - 1);
                this.m_outputData.data.digital_pe = (short)(this.m_outputData.data.digital_pe & ~(1 << channel - 1));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPWMPeriod(tPWMPeriodChannels channels) throws EnhancedIOException {
        if (!this.m_outputValid) {
            this.m_requestEnhancedEnable = true;
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            int tempData = this.m_outputData.data.pwm_period[channels.value];
            tempData = tempData < 0 ? tempData + 65536 : tempData;
            return (double)tempData / 2.4E7;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPWMPeriod(tPWMPeriodChannels channels, double period) throws EnhancedIOException {
        double ticks = period * 2.4E7;
        if (ticks > 65534.0) {
            ticks = 65534.0;
            throw new EnhancedIOException("Enhanced IO PWM Period Out of Range");
        }
        if (ticks < 0.0) {
            ticks = 0.0;
        }
        double[] dutyCycles = new double[]{this.getPWMOutput((channels.value << 1) + 1), this.getPWMOutput((channels.value << 1) + 2)};
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_outputData.data.pwm_period[channels.value] = (short)ticks;
            this.m_configChanged = true;
        }
        this.setPWMOutput((channels.value << 1) + 1, dutyCycles[0]);
        this.setPWMOutput((channels.value << 1) + 2, dutyCycles[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFixedDigitalOutput(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 2.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            return (this.m_outputData.data.fixed_digital_out >> channel - 1 & 1) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFixedDigitalOutput(int channel, boolean value) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 2.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            byte digital = this.m_outputData.data.fixed_digital_out;
            digital = (byte)(digital & ~(1 << channel - 1));
            if (value) {
                digital = (byte)(digital | 1 << channel - 1);
            }
            this.m_outputData.data.fixed_digital_out = digital;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getEncoder(int encoderNumber) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(encoderNumber, 1.0, 2.0);
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return (short)(this.m_inputData.data.quad[encoderNumber - 1] - this.m_encoderOffsets[encoderNumber - 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetEncoder(int encoderNumber) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(encoderNumber, 1.0, 2.0);
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            this.m_encoderOffsets[encoderNumber - 1] = this.m_inputData.data.quad[encoderNumber - 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getEncoderIndexEnable(int encoderNumber) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(encoderNumber, 1.0, 2.0);
        if (!this.m_outputValid) {
            this.m_requestEnhancedEnable = true;
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            return (this.m_outputData.data.quad_index_enable >> encoderNumber - 1 & 1) != 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEncoderIndexEnable(int encoderNumber, boolean enable) {
        BoundaryException.assertWithinBounds(encoderNumber, 1.0, 2.0);
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_outputData.data.quad_index_enable = (byte)(this.m_outputData.data.quad_index_enable & ~(1 << encoderNumber - 1));
            if (enable) {
                this.m_outputData.data.quad_index_enable = (byte)(this.m_outputData.data.quad_index_enable | 1 << encoderNumber - 1);
            }
            this.m_configChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTouchSlider() throws EnhancedIOException {
        if (!this.m_inputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            int rawValue = this.m_inputData.data.capsense_slider;
            int value = rawValue < 0 ? rawValue + 256 : rawValue;
            return value == 255 ? -1.0 : (double)value / 254.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPWMOutput(int channel) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 4.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            int tempCompare = this.m_outputData.data.pwm_compare[channel - 1];
            tempCompare = tempCompare < 0 ? tempCompare + 65536 : tempCompare;
            int tempPeriod = this.m_outputData.data.pwm_period[channel - 1 >> 1];
            tempPeriod = tempPeriod < 0 ? tempPeriod + 65536 : tempPeriod;
            return (double)tempCompare / (double)tempPeriod;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPWMOutput(int channel, double value) throws EnhancedIOException {
        BoundaryException.assertWithinBounds(channel, 1.0, 4.0);
        if (!this.m_outputValid) {
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        if (value > 1.0) {
            value = 1.0;
        } else if (value < 0.0) {
            value = 0.0;
        }
        Object object = this.m_outputDataSemaphore;
        synchronized (object) {
            this.m_outputData.data.pwm_compare[channel - 1] = (short)(value * (double)this.m_outputData.data.pwm_period[channel - 1 >> 1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte getFirmwareVersion() throws EnhancedIOException {
        if (!this.m_inputValid) {
            this.m_requestEnhancedEnable = true;
            throw new EnhancedIOException("Enhanced IO Missing");
        }
        Object object = this.m_inputDataSemaphore;
        synchronized (object) {
            return this.m_inputData.data.fw_version;
        }
    }

    public static class tPWMPeriodChannels {
        public final int value;
        static final int kPWMChannels1and2_val = 0;
        static final int kPWMChannels3and4_val = 1;
        public static final tPWMPeriodChannels kPWMChannels1and2 = new tPWMPeriodChannels(0);
        public static final tPWMPeriodChannels kPWMChannels3and4 = new tPWMPeriodChannels(1);

        private tPWMPeriodChannels(int value) {
            this.value = value;
        }
    }

    public static class tAccelChannel {
        public final int value;
        static final int kAccelX_val = 0;
        static final int kAccelY_val = 1;
        static final int kAccelZ_val = 2;
        public static final tAccelChannel kAccelX = new tAccelChannel(0);
        public static final tAccelChannel kAccelY = new tAccelChannel(1);
        public static final tAccelChannel kAccelZ = new tAccelChannel(2);

        private tAccelChannel(int value) {
            this.value = value;
        }
    }

    public static class tDigitalConfig {
        public final int value;
        static final int kUnknown_val = 0;
        static final int kInputFloating_val = 1;
        static final int kInputPullUp_val = 2;
        static final int kInputPullDown_val = 3;
        static final int kOutput_val = 4;
        static final int kPWM_val = 5;
        static final int kAnalogComparator_val = 6;
        public static final tDigitalConfig kUnknown = new tDigitalConfig(0);
        public static final tDigitalConfig kInputFloating = new tDigitalConfig(1);
        public static final tDigitalConfig kInputPullUp = new tDigitalConfig(2);
        public static final tDigitalConfig kInputPullDown = new tDigitalConfig(3);
        public static final tDigitalConfig kOutput = new tDigitalConfig(4);
        public static final tDigitalConfig kPWM = new tDigitalConfig(5);
        public static final tDigitalConfig kAnalogComparator = new tDigitalConfig(6);

        private tDigitalConfig(int value) {
            this.value = value;
        }
    }

    public static class EnhancedIOException
    extends Exception {
        public EnhancedIOException(String msg) {
            super(msg);
        }
    }

    class control_block_t
    extends FRCControl.DynamicControlData {
        byte size = (byte)34;
        byte id = (byte)17;
        input_t data;

        control_block_t() {
            this.allocateMemory();
            this.data = new input_t(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), input_t.size));
        }

        public void read() {
            this.size = this.backingNativeMemory.getByte(0L);
            this.id = this.backingNativeMemory.getByte(1L);
            this.data.read();
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.size);
            this.backingNativeMemory.setByte(1L, this.id);
            this.data.write();
        }

        public int size() {
            return 35;
        }

        public void copy(control_block_t dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    class status_block_t
    extends FRCControl.DynamicControlData {
        byte size = (byte)25;
        byte id = (byte)18;
        output_t data;
        byte flags;

        status_block_t() {
            this.allocateMemory();
            this.data = new output_t(new Pointer((long)(this.backingNativeMemory.address().toUWord().toPrimitive() + 2), output_t.size));
        }

        public void read() {
            this.size = this.backingNativeMemory.getByte(0L);
            this.id = this.backingNativeMemory.getByte(1L);
            this.data.read();
            this.flags = this.backingNativeMemory.getByte(25L);
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.size);
            this.backingNativeMemory.setByte(1L, this.id);
            this.data.write();
            this.backingNativeMemory.setByte(25L, this.flags);
        }

        public int size() {
            return 26;
        }

        public void copy(status_block_t dest) {
            this.write();
            Pointer.copyBytes((Pointer)this.backingNativeMemory, (int)0, (Pointer)dest.backingNativeMemory, (int)0, (int)this.size());
            dest.read();
        }
    }

    static class input_t
    extends Structure {
        byte api_version;
        byte fw_version;
        short[] analog = new short[8];
        short digital;
        short[] accel = new short[3];
        short[] quad = new short[2];
        byte buttons;
        byte capsense_slider;
        byte capsense_proximity;
        static int size = 33;

        public input_t(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.api_version = this.backingNativeMemory.getByte(0L);
            this.fw_version = this.backingNativeMemory.getByte(1L);
            this.backingNativeMemory.getShorts(2L, this.analog, 0, this.analog.length);
            this.digital = this.backingNativeMemory.getShort(18L);
            this.backingNativeMemory.getShorts(20L, this.accel, 0, this.accel.length);
            this.backingNativeMemory.getShorts(26L, this.quad, 0, this.quad.length);
            this.buttons = this.backingNativeMemory.getByte(30L);
            this.capsense_slider = this.backingNativeMemory.getByte(31L);
            this.capsense_proximity = this.backingNativeMemory.getByte(32L);
        }

        public void write() {
            this.backingNativeMemory.setByte(0L, this.api_version);
            this.backingNativeMemory.setByte(1L, this.fw_version);
            this.backingNativeMemory.setShorts(2L, this.analog, 0, this.analog.length);
            this.backingNativeMemory.setShort(18L, this.digital);
            this.backingNativeMemory.setShorts(20L, this.accel, 0, this.accel.length);
            this.backingNativeMemory.setShorts(26L, this.quad, 0, this.quad.length);
            this.backingNativeMemory.setByte(30L, this.buttons);
            this.backingNativeMemory.setByte(31L, this.capsense_slider);
            this.backingNativeMemory.setByte(32L, this.capsense_proximity);
        }

        public int size() {
            return size;
        }
    }

    static class output_t
    extends Structure {
        short digital = 0;
        short digital_oe = 0;
        short digital_pe = 0;
        short[] pwm_compare = new short[4];
        short[] pwm_period = new short[2];
        byte[] dac = new byte[2];
        byte leds = 0;
        private byte enables = 0;
        byte pwm_enable = 0;
        byte comparator_enable = 0;
        byte quad_index_enable = 0;
        byte fixed_digital_out = 0;
        static int size = 23;

        public void setEnables(byte enablesByte) {
            this.enables = enablesByte;
            this.pwm_enable = (byte)((enablesByte & 0xFFFFFFF0) >> 4);
            this.comparator_enable = (byte)((enablesByte & 0xC) >> 2);
            this.quad_index_enable = (byte)(enablesByte & 3);
        }

        public byte getEnables() {
            this.enables = (byte)(this.pwm_enable << 4 & 0xFFFFFFF0 | this.comparator_enable << 2 & 0xC | this.quad_index_enable & 3);
            return this.enables;
        }

        public output_t(Pointer backingMemory) {
            this.useMemory(backingMemory);
        }

        public void read() {
            this.digital = this.backingNativeMemory.getShort(0L);
            this.digital_oe = this.backingNativeMemory.getShort(2L);
            this.digital_pe = this.backingNativeMemory.getShort(4L);
            this.backingNativeMemory.getShorts(6L, this.pwm_compare, 0, this.pwm_compare.length);
            this.backingNativeMemory.getShorts(14L, this.pwm_period, 0, this.pwm_period.length);
            this.backingNativeMemory.getBytes(18L, this.dac, 0, this.dac.length);
            this.leds = this.backingNativeMemory.getByte(20L);
            this.setEnables(this.backingNativeMemory.getByte(21L));
            this.fixed_digital_out = this.backingNativeMemory.getByte(22L);
        }

        public void write() {
            this.backingNativeMemory.setShort(0L, this.digital);
            this.backingNativeMemory.setShort(2L, this.digital_oe);
            this.backingNativeMemory.setShort(4L, this.digital_pe);
            this.backingNativeMemory.setShorts(6L, this.pwm_compare, 0, this.pwm_compare.length);
            this.backingNativeMemory.setShorts(14L, this.pwm_period, 0, this.pwm_period.length);
            this.backingNativeMemory.setBytes(18L, this.dac, 0, this.dac.length);
            this.backingNativeMemory.setByte(20L, this.leds);
            this.backingNativeMemory.setByte(21L, this.getEnables());
            this.backingNativeMemory.setByte(22L, this.fixed_digital_out);
        }

        public int size() {
            return size;
        }
    }
}

