/*
 * Decompiled with CFR 0.152.
 */
package com.ni.rio;

import com.sun.cldc.jna.ptr.IntByReference;

public class NiRioStatus {
    private IntByReference status = new IntByReference(0);
    public static final int kRioStatusOffset = -63000;
    public static final int kRioStatusSuccess = 0;
    public static final int kRioStatusDmaOutputNotSupported = -63001;
    public static final int kRIOStatusIOInvalidAddressRange = -63010;
    public static final int kRIOStatusIOInvalidBuffer = -63011;
    public static final int kRIOStatusDeviceReconfigured = -63030;
    public static final int kRIOStatusDeviceInvariant = -63031;
    public static final int kRIOStatusDeviceInvalidStateTransition = -63032;
    public static final int kRIOStatusAccessDenied = -63033;
    public static final int kRIOStatusRPCConnectionError = -63040;
    public static final int kRIOStatusRPCServerError = -63041;
    public static final int kRIOStatusNetworkFault = -63042;
    public static final int kRIOStatusRioRpcSessionError = -63043;
    public static final int kRIOStatusTriggerReserved = -63050;
    public static final int kRIOStatusTriggerNotReserved = -63051;
    public static final int kRIOStatusTriggerNotSupported = -63052;
    public static final int kRIOStatusEventInvalid = -63070;
    public static final int kRIOStatusEventEnabled = -63071;
    public static final int kRIOStatusEventNotEnabled = -63072;
    public static final int kRIOStatusEventTimedOut = -63073;
    public static final int kRIOStatusEventInvalidOperation = -63074;
    public static final int kRIOStatusBufferInvalidSize = -63080;
    public static final int kRIOStatusBufferNotAllocated = -63081;
    public static final int kRIOStatusFifoReserved = -63082;
    public static final int kRIOStatusHardwareFault = -63150;
    public static final int kRIOStatusResourceInitialized = -63151;
    public static final int kRIOStatusResourceNotFound = -63152;
    public static final int kRIOStatusInvalidAliasName = -63180;
    public static final int kRIOStatusAliasNotFound = -63181;
    public static final int kRIOStatusInvalidDeviceAccess = -63182;
    public static final int kRIOStatusInvalidPort = -63183;
    public static final int kRIOStatusRemoteTarget = -63187;
    public static final int kRIOStatusDeprecatedFunction = -63188;
    public static final int kRIOStatusInvalidPattern = -63189;
    public static final int kRIOStatusBadDeviceControlCode = -63190;
    public static final int kRIOStatusInvalidResourceName = -63192;
    public static final int kRIOStatusFeatureNotSupported = -63193;
    public static final int kRIOStatusVersionMismatch = -63194;
    public static final int kRIOStatusInvalidHandle = -63195;
    public static final int kRIOStatusInvalidAttribute = -63196;
    public static final int kRIOStatusInvalidAttributeValue = -63197;
    public static final int kRIOStatusOutOfHandles = -63198;
    public static final int kRIOStatusInvalidFunction = -63199;
    public static final int kRIOStatusMemoryFull = -52000;
    public static final int kRIOStatusPageLockFailed = -52001;
    public static final int kRIOStatusSoftwareFault = -52003;
    public static final int kRIOStatusDynamicCastFailed = -52004;
    public static final int kRIOStatusInvalidParameter = -52005;
    public static final int kRIOStatusOperationTimedOut = -52007;
    public static final int kRIOStatusOSFault = -52008;
    public static final int kRIOStatusMarkedForDelete = -52009;
    public static final int kRIOStatusResourceNotInitialized = -52010;
    public static final int kRIOStatusOperationPending = -52011;
    public static final int kRIOStatusEndOfData = -52012;
    public static final int kRIOStatusObjectNameCollision = -52013;
    public static final int kRIOStatusSyncObjectAbandoned = -52014;
    public static final int kRIOStatusSyncAcquireFailed = -52015;
    public static final int kRIOStatusThreadAlreadyStarted = -52016;
    public static final int kRIOStatusInvalidStateTransition = -52017;
    public static final int kRIOStatusIrrelevantAttribute = -50001;
    public static final int kRIOStatusBadSelector = -50003;
    public static final int kRIOStatusComponentNotFound = -50251;
    public static final int kRIOStatusDeviceNotFound = -50300;
    public static final int kRIOStatusFileError = -6;

    public int getPointer() {
        return this.status.getPointer().address().toUWord().toPrimitive();
    }

    public boolean isFatal() {
        return this.status.getValue() < 0;
    }

    public boolean isNotFatal() {
        return this.status.getValue() >= 0;
    }

    public void setStatus(int newStatusCode) {
        if (this.status.getValue() >= 0 && (this.status.getValue() == 0 || newStatusCode < 0)) {
            this.status.setValue(newStatusCode);
        }
        this.assertNonfatal();
    }

    public void setStatus(NiRioStatus newStatus) {
        this.setStatus(newStatus.getStatusCode());
    }

    public int getStatusCode() {
        return this.status.getValue();
    }

    public void assertNonfatal() throws IllegalStateException {
        if (this.isFatal()) {
            throw new FatalStatusException(this, "Fatal status code detected:  " + Integer.toString(this.getStatusCode()));
        }
    }

    public static final class FatalStatusException
    extends IllegalStateException {
        NiRioStatus m_status;

        public FatalStatusException(NiRioStatus status, String message) {
            super(message);
            this.m_status = status;
        }

        public NiRioStatus getStatus() {
            return this.m_status;
        }
    }
}

