/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.sun.cldc.jna.BlockingFunction;
import com.sun.cldc.jna.Function;
import com.sun.cldc.jna.NativeLibrary;
import com.sun.cldc.jna.Pointer;
import com.sun.cldc.jna.Structure;
import com.sun.cldc.jna.TaskExecutor;
import com.sun.cldc.jna.ptr.IntByReference;
import edu.wpi.first.wpilibj.image.CurveOptions;
import edu.wpi.first.wpilibj.image.EllipseDescriptor;
import edu.wpi.first.wpilibj.image.EllipseMatch;
import edu.wpi.first.wpilibj.image.MonoImage;
import edu.wpi.first.wpilibj.image.NIVisionException;
import edu.wpi.first.wpilibj.image.RegionOfInterest;
import edu.wpi.first.wpilibj.image.ShapeDetectionOptions;
import edu.wpi.first.wpilibj.util.BoundaryException;

class NIVision {
    static final TaskExecutor taskExecutor = new TaskExecutor("nivision task");
    private static final BlockingFunction imaqGetLastErrorFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqGetLastError");
    private static final BlockingFunction Priv_ReadJPEGString_CFn;
    private static final BlockingFunction Priv_SetWriteFileAllowedFn;
    protected static final BlockingFunction imaqCreateImageFn;
    private static final Function imaqWriteFileFn;
    private static final BlockingFunction imaqReadFileFn;
    private static final BlockingFunction imaqColorThresholdFn;
    private static final BlockingFunction imaqCountParticlesFn;
    private static final BlockingFunction imaqMeasureParticleFn;
    private static final BlockingFunction imaqDisposeFn;
    private static final BlockingFunction imaqGetImageSizeFn;
    private static final BlockingFunction imaqExtractColorPlanesFn;
    private static final BlockingFunction imaqReplaceColorPlanesFn;
    private static final BlockingFunction imaqColorEqualizeFn;
    private static final BlockingFunction imaqDetectEllipsesFn;
    private static Pointer numberOfEllipsesDetected;

    NIVision() {
    }

    protected static void assertCleanStatus(int code) throws NIVisionException {
        if (code == 0) {
            throw new NIVisionException(imaqGetLastErrorFn.call0());
        }
    }

    public static void readJpegString(Pointer image, Pointer p) {
        Priv_ReadJPEGString_CFn.call3(image, p, p.getSize());
    }

    public static void setWriteFileAllowed(boolean val) {
        Priv_SetWriteFileAllowedFn.call1(val ? 1 : 0);
    }

    public static Pointer imaqCreateImage(ImageType type, int borderSize) throws NIVisionException {
        int toReturn = imaqCreateImageFn.call2(type.value, borderSize);
        NIVision.assertCleanStatus(toReturn);
        return new Pointer((long)toReturn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Pointer image, String fileName) throws NIVisionException {
        Pointer p = new Pointer(fileName.length() + 1);
        p.setString(0, fileName);
        NIVision.setWriteFileAllowed(true);
        try {
            NIVision.assertCleanStatus(imaqWriteFileFn.call3(image, p, 0));
        }
        finally {
            p.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(Pointer image, String fileName, Pointer colorTable) throws NIVisionException {
        Pointer p = new Pointer(fileName.length() + 1);
        p.setString(0, fileName);
        NIVision.setWriteFileAllowed(true);
        try {
            NIVision.assertCleanStatus(imaqWriteFileFn.call3(image, p, colorTable));
        }
        finally {
            p.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readFile(Pointer image, String fileName) throws NIVisionException {
        Pointer p = new Pointer(fileName.length() + 1);
        p.setString(0, fileName);
        try {
            NIVision.assertCleanStatus(imaqReadFileFn.call4(image, p, 0, 0));
        }
        finally {
            p.free();
        }
    }

    public static void colorThreshold(Pointer dest, Pointer source, ColorMode mode, Pointer plane1Range, Pointer plane2Range, Pointer plane3Range) throws NIVisionException {
        int replaceValue = 1;
        NIVision.assertCleanStatus(imaqColorThresholdFn.call7(dest.address().toUWord().toPrimitive(), source.address().toUWord().toPrimitive(), replaceValue, mode.value, plane1Range.address().toUWord().toPrimitive(), plane2Range.address().toUWord().toPrimitive(), plane3Range.address().toUWord().toPrimitive()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countParticles(Pointer image) throws NIVisionException {
        int val;
        IntByReference i = new IntByReference(0);
        try {
            NIVision.assertCleanStatus(imaqCountParticlesFn.call3(image, 1, i.getPointer()));
        }
        finally {
            val = i.getValue();
            i.free();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double MeasureParticle(Pointer image, int particleNum, boolean calibrated, MeasurementType type) throws NIVisionException {
        double val;
        Pointer l = new Pointer(8);
        try {
            NIVision.assertCleanStatus(imaqMeasureParticleFn.call5(image, particleNum, calibrated ? 1 : 0, type.value, l));
        }
        finally {
            val = l.getDouble(0L);
            l.free();
        }
        return val;
    }

    public static void dispose(Pointer item) throws NIVisionException {
        NIVision.assertCleanStatus(imaqDisposeFn.call1(item));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getHeight(Pointer image) throws NIVisionException {
        int val;
        Pointer i = new Pointer(4);
        try {
            NIVision.assertCleanStatus(imaqGetImageSizeFn.call3(image, 0, i));
        }
        finally {
            val = i.getInt(0L);
            i.free();
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWidth(Pointer image) throws NIVisionException {
        int val;
        Pointer i = new Pointer(4);
        try {
            NIVision.assertCleanStatus(imaqGetImageSizeFn.call3(image, i, 0));
        }
        finally {
            val = i.getInt(0L);
            i.free();
        }
        return val;
    }

    public static void extractColorPlanes(Pointer source, ColorMode mode, Pointer plane1, Pointer plane2, Pointer plane3) throws NIVisionException {
        int plane_1 = 0;
        int plane_2 = 0;
        int plane_3 = 0;
        if (plane1 != null) {
            plane_1 = plane1.address().toUWord().toPrimitive();
        }
        if (plane2 != null) {
            plane_2 = plane2.address().toUWord().toPrimitive();
        }
        if (plane3 != null) {
            plane_3 = plane3.address().toUWord().toPrimitive();
        }
        NIVision.assertCleanStatus(imaqExtractColorPlanesFn.call5(source, mode.value, plane_1, plane_2, plane_3));
    }

    public static void replaceColorPlanes(Pointer dest, Pointer source, ColorMode mode, Pointer plane1, Pointer plane2, Pointer plane3) throws NIVisionException {
        int plane_1 = 0;
        int plane_2 = 0;
        int plane_3 = 0;
        if (plane1 != null) {
            plane_1 = plane1.address().toUWord().toPrimitive();
        }
        if (plane2 != null) {
            plane_2 = plane2.address().toUWord().toPrimitive();
        }
        if (plane3 != null) {
            plane_3 = plane3.address().toUWord().toPrimitive();
        }
        NIVision.assertCleanStatus(imaqReplaceColorPlanesFn.call6(dest.address().toUWord().toPrimitive(), source.address().toUWord().toPrimitive(), mode.value, plane_1, plane_2, plane_3));
    }

    public static void colorEqualize(Pointer destination, Pointer source, boolean all) throws NIVisionException {
        NIVision.assertCleanStatus(imaqColorEqualizeFn.call3(destination, source, all ? 1 : 0));
    }

    public static EllipseMatch[] detectEllipses(MonoImage image, EllipseDescriptor ellipseDescriptor, CurveOptions curveOptions, ShapeDetectionOptions shapeDetectionOptions, RegionOfInterest roi) throws NIVisionException {
        int returnedAddress;
        block5: {
            int curveOptionsPointer = 0;
            if (curveOptions != null) {
                curveOptionsPointer = curveOptions.getPointer().address().toUWord().toPrimitive();
            }
            int shapeDetectionOptionsPointer = 0;
            if (shapeDetectionOptions != null) {
                shapeDetectionOptionsPointer = shapeDetectionOptions.getPointer().address().toUWord().toPrimitive();
            }
            int roiPointer = 0;
            if (roi != null) {
                roiPointer = roi.getPointer().address().toUWord().toPrimitive();
            }
            returnedAddress = imaqDetectEllipsesFn.call6(image.image.address().toUWord().toPrimitive(), ellipseDescriptor.getPointer().address().toUWord().toPrimitive(), curveOptionsPointer, shapeDetectionOptionsPointer, roiPointer, numberOfEllipsesDetected.address().toUWord().toPrimitive());
            try {
                NIVision.assertCleanStatus(returnedAddress);
            }
            catch (NIVisionException ex) {
                if (ex.getMessage().equals("No error.")) break block5;
                throw ex;
            }
        }
        EllipseMatch[] matches = EllipseMatch.getMatchesFromMemory(returnedAddress, numberOfEllipsesDetected.getInt(0L));
        NIVision.dispose(new Pointer((long)returnedAddress, 0));
        return matches;
    }

    static {
        imaqGetLastErrorFn.setTaskExecutor(taskExecutor);
        Priv_ReadJPEGString_CFn = NativeLibrary.getDefaultInstance().getBlockingFunction("Priv_ReadJPEGString_C");
        Priv_ReadJPEGString_CFn.setTaskExecutor(taskExecutor);
        Priv_SetWriteFileAllowedFn = NativeLibrary.getDefaultInstance().getBlockingFunction("Priv_SetWriteFileAllowed");
        Priv_SetWriteFileAllowedFn.setTaskExecutor(taskExecutor);
        imaqCreateImageFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqCreateImage");
        imaqCreateImageFn.setTaskExecutor(taskExecutor);
        imaqWriteFileFn = NativeLibrary.getDefaultInstance().getFunction("imaqWriteFile");
        imaqReadFileFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqReadFile");
        imaqReadFileFn.setTaskExecutor(taskExecutor);
        imaqColorThresholdFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqColorThreshold");
        imaqColorThresholdFn.setTaskExecutor(taskExecutor);
        imaqCountParticlesFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqCountParticles");
        imaqCountParticlesFn.setTaskExecutor(taskExecutor);
        imaqMeasureParticleFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqMeasureParticle");
        imaqMeasureParticleFn.setTaskExecutor(taskExecutor);
        imaqDisposeFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqDispose");
        imaqDisposeFn.setTaskExecutor(taskExecutor);
        imaqGetImageSizeFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqGetImageSize");
        imaqGetImageSizeFn.setTaskExecutor(taskExecutor);
        imaqExtractColorPlanesFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqExtractColorPlanes");
        imaqExtractColorPlanesFn.setTaskExecutor(taskExecutor);
        imaqReplaceColorPlanesFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqReplaceColorPlanes");
        imaqReplaceColorPlanesFn.setTaskExecutor(taskExecutor);
        imaqColorEqualizeFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqColorEqualize");
        imaqColorEqualizeFn.setTaskExecutor(taskExecutor);
        imaqDetectEllipsesFn = NativeLibrary.getDefaultInstance().getBlockingFunction("imaqDetectEllipses");
        imaqDetectEllipsesFn.setTaskExecutor(taskExecutor);
        numberOfEllipsesDetected = new Pointer(4);
    }

    public static class Range
    extends Structure {
        int lower;
        int upper;

        public void read() {
            this.lower = this.backingNativeMemory.getInt(0L);
            this.upper = this.backingNativeMemory.getInt(4L);
        }

        public void write() {
            this.backingNativeMemory.setInt(0L, this.lower);
            this.backingNativeMemory.setInt(4L, this.upper);
        }

        public int size() {
            return 8;
        }

        public void free() {
            this.release();
        }

        public Range(int lower, int upper) {
            this.allocateMemory();
            this.set(lower, upper);
        }

        public void set(int lower, int upper) {
            if (lower > upper) {
                throw new BoundaryException("Lower boundary is greater than upper");
            }
            this.lower = lower;
            this.upper = upper;
            this.write();
        }

        public int getLower() {
            this.read();
            return this.lower;
        }

        public int getUpper() {
            this.read();
            return this.upper;
        }
    }

    public static class MeasurementType {
        public final int value;
        public static final MeasurementType IMAQ_MT_CENTER_OF_MASS_X = new MeasurementType(0);
        public static final MeasurementType IMAQ_MT_CENTER_OF_MASS_Y = new MeasurementType(1);
        public static final MeasurementType IMAQ_MT_FIRST_PIXEL_X = new MeasurementType(2);
        public static final MeasurementType IMAQ_MT_FIRST_PIXEL_Y = new MeasurementType(3);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_LEFT = new MeasurementType(4);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_TOP = new MeasurementType(5);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_RIGHT = new MeasurementType(6);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_BOTTOM = new MeasurementType(7);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER_START_X = new MeasurementType(8);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER_START_Y = new MeasurementType(9);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER_END_X = new MeasurementType(10);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER_END_Y = new MeasurementType(11);
        public static final MeasurementType IMAQ_MT_MAX_HORIZ_SEGMENT_LENGTH_LEFT = new MeasurementType(12);
        public static final MeasurementType IMAQ_MT_MAX_HORIZ_SEGMENT_LENGTH_RIGHT = new MeasurementType(13);
        public static final MeasurementType IMAQ_MT_MAX_HORIZ_SEGMENT_LENGTH_ROW = new MeasurementType(14);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_WIDTH = new MeasurementType(16);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_HEIGHT = new MeasurementType(17);
        public static final MeasurementType IMAQ_MT_BOUNDING_RECT_DIAGONAL = new MeasurementType(18);
        public static final MeasurementType IMAQ_MT_PERIMETER = new MeasurementType(19);
        public static final MeasurementType IMAQ_MT_CONVEX_HULL_PERIMETER = new MeasurementType(20);
        public static final MeasurementType IMAQ_MT_HOLES_PERIMETER = new MeasurementType(21);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER = new MeasurementType(22);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_ELLIPSE_MAJOR_AXIS = new MeasurementType(23);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_ELLIPSE_MINOR_AXIS = new MeasurementType(24);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_ELLIPSE_MINOR_AXIS_FERET = new MeasurementType(25);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_RECT_LONG_SIDE = new MeasurementType(26);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_RECT_SHORT_SIDE = new MeasurementType(27);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_RECT_DIAGONAL = new MeasurementType(28);
        public static final MeasurementType IMAQ_MT_EQUIVALENT_RECT_SHORT_SIDE_FERET = new MeasurementType(29);
        public static final MeasurementType IMAQ_MT_AVERAGE_HORIZ_SEGMENT_LENGTH = new MeasurementType(30);
        public static final MeasurementType IMAQ_MT_AVERAGE_VERT_SEGMENT_LENGTH = new MeasurementType(31);
        public static final MeasurementType IMAQ_MT_HYDRAULIC_RADIUS = new MeasurementType(32);
        public static final MeasurementType IMAQ_MT_WADDEL_DISK_DIAMETER = new MeasurementType(33);
        public static final MeasurementType IMAQ_MT_AREA = new MeasurementType(35);
        public static final MeasurementType IMAQ_MT_HOLES_AREA = new MeasurementType(36);
        public static final MeasurementType IMAQ_MT_PARTICLE_AND_HOLES_AREA = new MeasurementType(37);
        public static final MeasurementType IMAQ_MT_CONVEX_HULL_AREA = new MeasurementType(38);
        public static final MeasurementType IMAQ_MT_IMAGE_AREA = new MeasurementType(39);
        public static final MeasurementType IMAQ_MT_NUMBER_OF_HOLES = new MeasurementType(41);
        public static final MeasurementType IMAQ_MT_NUMBER_OF_HORIZ_SEGMENTS = new MeasurementType(42);
        public static final MeasurementType IMAQ_MT_NUMBER_OF_VERT_SEGMENTS = new MeasurementType(43);
        public static final MeasurementType IMAQ_MT_ORIENTATION = new MeasurementType(45);
        public static final MeasurementType IMAQ_MT_MAX_FERET_DIAMETER_ORIENTATION = new MeasurementType(46);
        public static final MeasurementType IMAQ_MT_AREA_BY_IMAGE_AREA = new MeasurementType(48);
        public static final MeasurementType IMAQ_MT_AREA_BY_PARTICLE_AND_HOLES_AREA = new MeasurementType(49);
        public static final MeasurementType IMAQ_MT_RATIO_OF_EQUIVALENT_ELLIPSE_AXES = new MeasurementType(50);
        public static final MeasurementType IMAQ_MT_RATIO_OF_EQUIVALENT_RECT_SIDES = new MeasurementType(51);
        public static final MeasurementType IMAQ_MT_ELONGATION_FACTOR = new MeasurementType(53);
        public static final MeasurementType IMAQ_MT_COMPACTNESS_FACTOR = new MeasurementType(54);
        public static final MeasurementType IMAQ_MT_HEYWOOD_CIRCULARITY_FACTOR = new MeasurementType(55);
        public static final MeasurementType IMAQ_MT_TYPE_FACTOR = new MeasurementType(56);
        public static final MeasurementType IMAQ_MT_SUM_X = new MeasurementType(58);
        public static final MeasurementType IMAQ_MT_SUM_Y = new MeasurementType(59);
        public static final MeasurementType IMAQ_MT_SUM_XX = new MeasurementType(60);
        public static final MeasurementType IMAQ_MT_SUM_XY = new MeasurementType(61);
        public static final MeasurementType IMAQ_MT_SUM_YY = new MeasurementType(62);
        public static final MeasurementType IMAQ_MT_SUM_XXX = new MeasurementType(63);
        public static final MeasurementType IMAQ_MT_SUM_XXY = new MeasurementType(64);
        public static final MeasurementType IMAQ_MT_SUM_XYY = new MeasurementType(65);
        public static final MeasurementType IMAQ_MT_SUM_YYY = new MeasurementType(66);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_XX = new MeasurementType(68);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_XY = new MeasurementType(69);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_YY = new MeasurementType(70);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_XXX = new MeasurementType(71);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_XXY = new MeasurementType(72);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_XYY = new MeasurementType(73);
        public static final MeasurementType IMAQ_MT_MOMENT_OF_INERTIA_YYY = new MeasurementType(74);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_XX = new MeasurementType(75);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_XY = new MeasurementType(76);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_YY = new MeasurementType(77);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_XXX = new MeasurementType(78);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_XXY = new MeasurementType(79);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_XYY = new MeasurementType(80);
        public static final MeasurementType IMAQ_MT_NORM_MOMENT_OF_INERTIA_YYY = new MeasurementType(81);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_1 = new MeasurementType(82);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_2 = new MeasurementType(83);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_3 = new MeasurementType(84);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_4 = new MeasurementType(85);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_5 = new MeasurementType(86);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_6 = new MeasurementType(87);
        public static final MeasurementType IMAQ_MT_HU_MOMENT_7 = new MeasurementType(88);
        public static final MeasurementType IMAQ_MEASUREMENT_TYPE_SIZE_GUARD = new MeasurementType(-1);

        private MeasurementType(int value) {
            this.value = value;
        }
    }

    public static class ColorMode {
        public final int value;
        public static final ColorMode IMAQ_RGB = new ColorMode(0);
        public static final ColorMode IMAQ_HSL = new ColorMode(1);
        public static final ColorMode IMAQ_HSV = new ColorMode(2);
        public static final ColorMode IMAQ_HSI = new ColorMode(3);
        public static final ColorMode IMAQ_CIE = new ColorMode(4);
        public static final ColorMode IMAQ_CIEXYZ = new ColorMode(5);
        public static final ColorMode IMAQ_COLOR_MODE_SIZE_GUARD = new ColorMode(-1);

        private ColorMode(int value) {
            this.value = value;
        }
    }

    public static class ImageType {
        public final int value;
        public static final ImageType imaqImageU8 = new ImageType(0);
        public static final ImageType imaqImageU16 = new ImageType(7);
        public static final ImageType imaqImageI16 = new ImageType(1);
        public static final ImageType imaqImageSGL = new ImageType(2);
        public static final ImageType imaqImageComplex = new ImageType(3);
        public static final ImageType imaqImageRGB = new ImageType(4);
        public static final ImageType imaqImageHSL = new ImageType(5);
        public static final ImageType imaqImageRGBU64 = new ImageType(6);
        public static final ImageType imaqImageTypeSizeGuard = new ImageType(-1);

        private ImageType(int value) {
            this.value = value;
        }
    }
}

