/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.image;

import com.sun.cldc.jna.Pointer;
import edu.wpi.first.wpilibj.image.MonoImage;
import edu.wpi.first.wpilibj.image.NIVision;
import edu.wpi.first.wpilibj.image.NIVisionException;
import edu.wpi.first.wpilibj.image.ParticleAnalysisReport;
import edu.wpi.first.wpilibj.util.SortedVector;

public class BinaryImage
extends MonoImage {
    private int numParticles = -1;

    BinaryImage() throws NIVisionException {
    }

    BinaryImage(BinaryImage sourceImage) {
        super(sourceImage);
    }

    public int getNumberParticles() throws NIVisionException {
        if (this.numParticles < 0) {
            this.numParticles = NIVision.countParticles(this.image);
        }
        return this.numParticles;
    }

    public ParticleAnalysisReport getParticleAnalysisReport(int index) throws NIVisionException {
        if (index >= this.getNumberParticles()) {
            throw new IndexOutOfBoundsException();
        }
        return new ParticleAnalysisReport(this, index);
    }

    public ParticleAnalysisReport[] getOrderedParticleAnalysisReports(int size) throws NIVisionException {
        if (size > this.getNumberParticles()) {
            size = this.getNumberParticles();
        }
        Object[] reports = new ParticleSizeReport[size];
        SortedVector sorter = new SortedVector(new SortedVector.Comparator(){

            public int compare(Object object1, Object object2) {
                ParticleSizeReport p1 = (ParticleSizeReport)object1;
                ParticleSizeReport p2 = (ParticleSizeReport)object2;
                if (p1.size < p2.size) {
                    return -1;
                }
                if (p1.size > p2.size) {
                    return 1;
                }
                return 0;
            }
        });
        for (int i = 0; i < this.getNumberParticles(); ++i) {
            sorter.addElement(new ParticleSizeReport(i));
        }
        sorter.setSize(size);
        sorter.copyInto(reports);
        ParticleAnalysisReport[] finalReports = new ParticleAnalysisReport[reports.length];
        for (int i = 0; i < finalReports.length; ++i) {
            finalReports[i] = ((ParticleSizeReport)reports[i]).getParticleAnalysisReport();
        }
        return finalReports;
    }

    public ParticleAnalysisReport[] getOrderedParticleAnalysisReports() throws NIVisionException {
        return this.getOrderedParticleAnalysisReports(this.getNumberParticles());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String fileName) throws NIVisionException {
        Pointer colorTable = new Pointer(1024);
        colorTable.setByte(0L, (byte)0);
        colorTable.setByte(1L, (byte)0);
        colorTable.setByte(2L, (byte)0);
        colorTable.setByte(3L, (byte)0);
        colorTable.setByte(4L, (byte)0);
        colorTable.setByte(5L, (byte)0);
        colorTable.setByte(6L, (byte)-1);
        colorTable.setByte(7L, (byte)0);
        try {
            NIVision.writeFile(this.image, fileName, colorTable);
        }
        finally {
            colorTable.free();
        }
    }

    private class ParticleSizeReport {
        final int index;
        final double size;

        public ParticleSizeReport(int index) throws NIVisionException {
            if (index >= BinaryImage.this.getNumberParticles() || index < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.index = index;
            this.size = ParticleAnalysisReport.getParticleToImagePercent(BinaryImage.this, index);
        }

        public ParticleAnalysisReport getParticleAnalysisReport() throws NIVisionException {
            return new ParticleAnalysisReport(BinaryImage.this, this.index);
        }
    }
}

