/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tInterrupt
extends tSystem {
    public static final int kNumSystems = 8;
    public final int m_SystemIndex;
    private static final int kInterrupt0_TimeStamp_Address = 33176;
    private static final int kInterrupt1_TimeStamp_Address = 33168;
    private static final int kInterrupt2_TimeStamp_Address = 33160;
    private static final int kInterrupt3_TimeStamp_Address = 33152;
    private static final int kInterrupt4_TimeStamp_Address = 33144;
    private static final int kInterrupt5_TimeStamp_Address = 33136;
    private static final int kInterrupt6_TimeStamp_Address = 33128;
    private static final int kInterrupt7_TimeStamp_Address = 33120;
    private static final int[] kTimeStamp_Addresses = new int[]{33176, 33168, 33160, 33152, 33144, 33136, 33128, 33120};
    private static final int kConfig_Source_Channel_BitfieldMask = 480;
    private static final int kConfig_Source_Channel_BitfieldOffset = 5;
    private static final int kConfig_Source_Module_BitfieldMask = 16;
    private static final int kConfig_Source_Module_BitfieldOffset = 4;
    private static final int kConfig_Source_AnalogTrigger_BitfieldMask = 8;
    private static final int kConfig_Source_AnalogTrigger_BitfieldOffset = 3;
    private static final int kConfig_RisingEdge_BitfieldMask = 4;
    private static final int kConfig_RisingEdge_BitfieldOffset = 2;
    private static final int kConfig_FallingEdge_BitfieldMask = 2;
    private static final int kConfig_FallingEdge_BitfieldOffset = 1;
    private static final int kConfig_WaitForAck_BitfieldMask = 1;
    private static final int kConfig_WaitForAck_BitfieldOffset = 0;
    private static final int kInterrupt0_Config_Address = 33036;
    private static final int kInterrupt1_Config_Address = 33172;
    private static final int kInterrupt2_Config_Address = 33164;
    private static final int kInterrupt3_Config_Address = 33156;
    private static final int kInterrupt4_Config_Address = 33148;
    private static final int kInterrupt5_Config_Address = 33140;
    private static final int kInterrupt6_Config_Address = 33132;
    private static final int kInterrupt7_Config_Address = 33124;
    private static final int[] kConfig_Addresses = new int[]{33036, 33172, 33164, 33156, 33148, 33140, 33132, 33124};

    public tInterrupt(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 8) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public long readTimeStamp() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kTimeStamp_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public void writeConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeConfig_Source_Channel(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFE1F;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 5 & 0x1E0, status);
    }

    public void writeConfig_Source_Module(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFEF;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= value << 4 & 0x10, status);
    }

    public void writeConfig_Source_AnalogTrigger(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF7;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 3 & 8, status);
    }

    public void writeConfig_RisingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFB;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 2 & 4, status);
    }

    public void writeConfig_FallingEdge(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFD;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 1 & 2, status);
    }

    public void writeConfig_WaitForAck(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiRioSrv.poke32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readConfig_Source_Channel() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1E0) >>> 5;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readConfig_Source_Module() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x10) >>> 4;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readConfig_Source_AnalogTrigger() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 8) >>> 3;
        return bitfieldValue != 0;
    }

    public boolean readConfig_RisingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 4) >>> 2;
        return bitfieldValue != 0;
    }

    public boolean readConfig_FallingEdge() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 2) >>> 1;
        return bitfieldValue != 0;
    }

    public boolean readConfig_WaitForAck() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }
}

