/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.fpga;

import com.ni.rio.NiRioSrv;
import edu.wpi.first.wpilibj.fpga.tSystem;

public class tDIO
extends tSystem {
    public static final int kNumSystems = 2;
    public final int m_SystemIndex;
    private static final int kDIO0_DO_Address = 33632;
    private static final int kDIO1_DO_Address = 33524;
    private static final int[] kDO_Addresses = new int[]{33632, 33524};
    private static final int kDIO0_I2CDataToSend_Address = 33576;
    private static final int kDIO1_I2CDataToSend_Address = 33468;
    private static final int[] kI2CDataToSend_Addresses = new int[]{33576, 33468};
    public static final int kFilterSelect_NumElements = 16;
    public static final int kFilterSelect_ElementSize = 2;
    public static final int kFilterSelect_ElementMask = 3;
    private static final int kDIO0_FilterSelect_Address = 33536;
    private static final int kDIO1_FilterSelect_Address = 33428;
    private static final int[] kFilterSelect_Addresses = new int[]{33536, 33428};
    public static final int kFilterPeriod_NumElements = 3;
    public static final int kFilterPeriod_ElementSize = 8;
    public static final int kFilterPeriod_ElementMask = 255;
    private static final int kDIO0_FilterPeriod_Address = 33540;
    private static final int kDIO1_FilterPeriod_Address = 33432;
    private static final int[] kFilterPeriod_Addresses = new int[]{33540, 33432};
    private static final int kDIO0_OutputEnable_Address = 33624;
    private static final int kDIO1_OutputEnable_Address = 33516;
    private static final int[] kOutputEnable_Addresses = new int[]{33624, 33516};
    private static final int kDIO0_DI_Address = 33628;
    private static final int kDIO1_DI_Address = 33520;
    private static final int[] kDI_Addresses = new int[]{33628, 33520};
    private static final int kDIO0_I2CDataReceived_Address = 33564;
    private static final int kDIO1_I2CDataReceived_Address = 33456;
    private static final int[] kI2CDataReceived_Addresses = new int[]{33564, 33456};
    private static final int kI2CStatus_Transaction_BitfieldMask = 0x4000000;
    private static final int kI2CStatus_Transaction_BitfieldOffset = 26;
    private static final int kI2CStatus_Done_BitfieldMask = 0x2000000;
    private static final int kI2CStatus_Done_BitfieldOffset = 25;
    private static final int kI2CStatus_Aborted_BitfieldMask = 0x1000000;
    private static final int kI2CStatus_Aborted_BitfieldOffset = 24;
    private static final int kI2CStatus_DataReceivedHigh_BitfieldMask = 0xFFFFFF;
    private static final int kI2CStatus_DataReceivedHigh_BitfieldOffset = 0;
    private static final int kDIO0_I2CStatus_Address = 33560;
    private static final int kDIO1_I2CStatus_Address = 33452;
    private static final int[] kI2CStatus_Addresses = new int[]{33560, 33452};
    private static final int kSlowValue_RelayFwd_BitfieldMask = 1044480;
    private static final int kSlowValue_RelayFwd_BitfieldOffset = 12;
    private static final int kSlowValue_RelayRev_BitfieldMask = 4080;
    private static final int kSlowValue_RelayRev_BitfieldOffset = 4;
    private static final int kSlowValue_I2CHeader_BitfieldMask = 15;
    private static final int kSlowValue_I2CHeader_BitfieldOffset = 0;
    private static final int kDIO0_SlowValue_Address = 33556;
    private static final int kDIO1_SlowValue_Address = 33448;
    private static final int[] kSlowValue_Addresses = new int[]{33556, 33448};
    public static final int kPWMPeriodScale_NumElements = 10;
    public static final int kPWMPeriodScale_ElementSize = 2;
    public static final int kPWMPeriodScale_ElementMask = 3;
    private static final int kDIO0_PWMPeriodScale_Address = 33580;
    private static final int kDIO1_PWMPeriodScale_Address = 33472;
    private static final int[] kPWMPeriodScale_Addresses = new int[]{33580, 33472};
    private static final int kDIO0_Pulse_Address = 33548;
    private static final int kDIO1_Pulse_Address = 33440;
    private static final int[] kPulse_Addresses = new int[]{33548, 33440};
    private static final int kDIO0_I2CStart_Address = 33568;
    private static final int kDIO1_I2CStart_Address = 33460;
    private static final int[] kI2CStart_Addresses = new int[]{33568, 33460};
    private static final int kDIO0_BFL_Address = 33552;
    private static final int kDIO1_BFL_Address = 33444;
    private static final int[] kBFL_Addresses = new int[]{33552, 33444};
    public static final int kDO_PWMDutyCycle_NumElements = 4;
    public static final int kDO_PWMDutyCycle_ElementSize = 8;
    public static final int kDO_PWMDutyCycle_ElementMask = 255;
    private static final int kDIO0_DO_PWMDutyCycle_Address = 33532;
    private static final int kDIO1_DO_PWMDutyCycle_Address = 33424;
    private static final int[] kDO_PWMDutyCycle_Addresses = new int[]{33532, 33424};
    private static final int kDIO0_PulseLength_Address = 33544;
    private static final int kDIO1_PulseLength_Address = 33436;
    private static final int[] kPulseLength_Addresses = new int[]{33544, 33436};
    private static final int kDO_PWMConfig_PeriodPower_BitfieldMask = 983040;
    private static final int kDO_PWMConfig_PeriodPower_BitfieldOffset = 16;
    private static final int kDO_PWMConfig_OutputSelect_0_BitfieldMask = 61440;
    private static final int kDO_PWMConfig_OutputSelect_0_BitfieldOffset = 12;
    private static final int kDO_PWMConfig_OutputSelect_1_BitfieldMask = 3840;
    private static final int kDO_PWMConfig_OutputSelect_1_BitfieldOffset = 8;
    private static final int kDO_PWMConfig_OutputSelect_2_BitfieldMask = 240;
    private static final int kDO_PWMConfig_OutputSelect_2_BitfieldOffset = 4;
    private static final int kDO_PWMConfig_OutputSelect_3_BitfieldMask = 15;
    private static final int kDO_PWMConfig_OutputSelect_3_BitfieldOffset = 0;
    private static final int kDIO0_DO_PWMConfig_Address = 33528;
    private static final int kDIO1_DO_PWMConfig_Address = 33420;
    private static final int[] kDO_PWMConfig_Addresses = new int[]{33528, 33420};
    private static final int kI2CConfig_Address_BitfieldMask = 2139095040;
    private static final int kI2CConfig_Address_BitfieldOffset = 23;
    private static final int kI2CConfig_BytesToRead_BitfieldMask = 0x700000;
    private static final int kI2CConfig_BytesToRead_BitfieldOffset = 20;
    private static final int kI2CConfig_BytesToWrite_BitfieldMask = 917504;
    private static final int kI2CConfig_BytesToWrite_BitfieldOffset = 17;
    private static final int kI2CConfig_DataToSendHigh_BitfieldMask = 131070;
    private static final int kI2CConfig_DataToSendHigh_BitfieldOffset = 1;
    private static final int kI2CConfig_BitwiseHandshake_BitfieldMask = 1;
    private static final int kI2CConfig_BitwiseHandshake_BitfieldOffset = 0;
    private static final int kDIO0_I2CConfig_Address = 33572;
    private static final int kDIO1_I2CConfig_Address = 33464;
    private static final int[] kI2CConfig_Addresses = new int[]{33572, 33464};
    private static final int kDIO_LoopTiming_Address = 33640;
    private static final int kPWMConfig_Period_BitfieldMask = -65536;
    private static final int kPWMConfig_Period_BitfieldOffset = 16;
    private static final int kPWMConfig_MinHigh_BitfieldMask = 65535;
    private static final int kPWMConfig_MinHigh_BitfieldOffset = 0;
    private static final int kDIO_PWMConfig_Address = 33636;
    public static final int kPWMValue_NumRegisters = 10;
    private static final int kDIO0_PWMValue0_Address = 33620;
    private static final int kDIO0_PWMValue1_Address = 33616;
    private static final int kDIO0_PWMValue2_Address = 33612;
    private static final int kDIO0_PWMValue3_Address = 33608;
    private static final int kDIO0_PWMValue4_Address = 33604;
    private static final int kDIO0_PWMValue5_Address = 33600;
    private static final int kDIO0_PWMValue6_Address = 33596;
    private static final int kDIO0_PWMValue7_Address = 33592;
    private static final int kDIO0_PWMValue8_Address = 33588;
    private static final int kDIO0_PWMValue9_Address = 33584;
    private static final int kDIO1_PWMValue0_Address = 33512;
    private static final int kDIO1_PWMValue1_Address = 33508;
    private static final int kDIO1_PWMValue2_Address = 33504;
    private static final int kDIO1_PWMValue3_Address = 33500;
    private static final int kDIO1_PWMValue4_Address = 33496;
    private static final int kDIO1_PWMValue5_Address = 33492;
    private static final int kDIO1_PWMValue6_Address = 33488;
    private static final int kDIO1_PWMValue7_Address = 33484;
    private static final int kDIO1_PWMValue8_Address = 33480;
    private static final int kDIO1_PWMValue9_Address = 33476;
    private static final int[] kPWMValue_Addresses = new int[]{33620, 33616, 33612, 33608, 33604, 33600, 33596, 33592, 33588, 33584, 33512, 33508, 33504, 33500, 33496, 33492, 33488, 33484, 33480, 33476};

    public tDIO(int sys_index) {
        this.m_SystemIndex = sys_index;
        if (status.isNotFatal() && this.m_SystemIndex >= 2) {
            status.setStatus(-50003);
        }
    }

    protected void finalize() {
        super.finalize();
    }

    public int getSystemIndex() {
        return this.m_SystemIndex;
    }

    public void writeDO(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kDO_Addresses[this.m_SystemIndex], value, status);
    }

    public int readDO() {
        return NiRioSrv.peek32(m_DeviceHandle, kDO_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public void writeI2CDataToSend(long value) {
        NiRioSrv.poke32(m_DeviceHandle, kI2CDataToSend_Addresses[this.m_SystemIndex], (int)value, status);
    }

    public long readI2CDataToSend() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kI2CDataToSend_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public void writeFilterSelect(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 16) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], status);
        regValue &= ~(3 << (15 - bitfield_index) * 2);
        NiRioSrv.poke32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], regValue |= (value & 3) << (15 - bitfield_index) * 2, status);
    }

    public byte readFilterSelect(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 16) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kFilterSelect_Addresses[this.m_SystemIndex], status) >>> (15 - bitfield_index) * 2 & 3;
        return (byte)(arrayElementValue & 3);
    }

    public void writeFilterPeriod(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 3) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], status);
        regValue &= ~(255 << (2 - bitfield_index) * 8);
        NiRioSrv.poke32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], regValue |= (value & 0xFF) << (2 - bitfield_index) * 8, status);
    }

    public short readFilterPeriod(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 3) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kFilterPeriod_Addresses[this.m_SystemIndex], status) >>> (2 - bitfield_index) * 8 & 0xFF;
        return (short)(arrayElementValue & 0xFF);
    }

    public void writeOutputEnable(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kOutputEnable_Addresses[this.m_SystemIndex], value, status);
    }

    public int readOutputEnable() {
        return NiRioSrv.peek32(m_DeviceHandle, kOutputEnable_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public int readDI() {
        return NiRioSrv.peek32(m_DeviceHandle, kDI_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public long readI2CDataReceived() {
        return (long)NiRioSrv.peek32(m_DeviceHandle, kI2CDataReceived_Addresses[this.m_SystemIndex], status) & 0xFFFFFFFFL;
    }

    public int readI2CStatus() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readI2CStatus_Transaction() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x4000000) >>> 26;
        return (byte)(bitfieldValue & 1);
    }

    public boolean readI2CStatus_Done() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x2000000) >>> 25;
        return bitfieldValue != 0;
    }

    public boolean readI2CStatus_Aborted() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1000000) >>> 24;
        return bitfieldValue != 0;
    }

    public int readI2CStatus_DataReceivedHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CStatus_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFFFFFF) >>> 0;
        return bitfieldValue & 0xFFFFFF;
    }

    public void writeSlowValue(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeSlowValue_RelayFwd(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF00FFF;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 12 & 0xFF000, status);
    }

    public void writeSlowValue_RelayRev(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF00F;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 4 & 0xFF0, status);
    }

    public void writeSlowValue_I2CHeader(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF0;
        NiRioSrv.poke32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], regValue |= value << 0 & 0xF, status);
    }

    public int readSlowValue() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public short readSlowValue_RelayFwd() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFF000) >>> 12;
        return (short)(bitfieldValue & 0xFF);
    }

    public short readSlowValue_RelayRev() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xFF0) >>> 4;
        return (short)(bitfieldValue & 0xFF);
    }

    public byte readSlowValue_I2CHeader() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kSlowValue_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF) >>> 0;
        return (byte)(bitfieldValue & 0xF);
    }

    public void writePWMPeriodScale(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 10) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], status);
        regValue &= ~(3 << (9 - bitfield_index) * 2);
        NiRioSrv.poke32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], regValue |= (value & 3) << (9 - bitfield_index) * 2, status);
    }

    public byte readPWMPeriodScale(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 10) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kPWMPeriodScale_Addresses[this.m_SystemIndex], status) >>> (9 - bitfield_index) * 2 & 3;
        return (byte)(arrayElementValue & 3);
    }

    public void writePulse(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kPulse_Addresses[this.m_SystemIndex], value, status);
    }

    public int readPulse() {
        return NiRioSrv.peek32(m_DeviceHandle, kPulse_Addresses[this.m_SystemIndex], status) & 0xFFFF;
    }

    public void strobeI2CStart() {
        NiRioSrv.poke32(m_DeviceHandle, kI2CStart_Addresses[this.m_SystemIndex], 1, status);
    }

    public void writeBFL(boolean value) {
        NiRioSrv.poke32(m_DeviceHandle, kBFL_Addresses[this.m_SystemIndex], value ? 1 : 0, status);
    }

    public boolean readBFL() {
        return NiRioSrv.peek32(m_DeviceHandle, kBFL_Addresses[this.m_SystemIndex], status) != 0;
    }

    public void writeDO_PWMDutyCycle(int bitfield_index, int value) {
        if (status.isNotFatal() && bitfield_index >= 4) {
            status.setStatus(-50003);
        }
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMDutyCycle_Addresses[this.m_SystemIndex], status);
        regValue &= ~(255 << (3 - bitfield_index) * 8);
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMDutyCycle_Addresses[this.m_SystemIndex], regValue |= (value & 0xFF) << (3 - bitfield_index) * 8, status);
    }

    public short readDO_PWMDutyCycle(int bitfield_index) {
        if (status.isNotFatal() && bitfield_index >= 4) {
            status.setStatus(-50003);
        }
        int arrayElementValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMDutyCycle_Addresses[this.m_SystemIndex], status) >>> (3 - bitfield_index) * 8 & 0xFF;
        return (short)(arrayElementValue & 0xFF);
    }

    public void writePulseLength(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kPulseLength_Addresses[this.m_SystemIndex], value, status);
    }

    public short readPulseLength() {
        return (short)(NiRioSrv.peek32(m_DeviceHandle, kPulseLength_Addresses[this.m_SystemIndex], status) & 0xFF);
    }

    public void writeDO_PWMConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeDO_PWMConfig_PeriodPower(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF0FFFF;
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], regValue |= value << 16 & 0xF0000, status);
    }

    public void writeDO_PWMConfig_OutputSelect_0(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFF0FFF;
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], regValue |= value << 12 & 0xF000, status);
    }

    public void writeDO_PWMConfig_OutputSelect_1(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFF0FF;
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], regValue |= value << 8 & 0xF00, status);
    }

    public void writeDO_PWMConfig_OutputSelect_2(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFF0F;
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], regValue |= value << 4 & 0xF0, status);
    }

    public void writeDO_PWMConfig_OutputSelect_3(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFF0;
        NiRioSrv.poke32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], regValue |= value << 0 & 0xF, status);
    }

    public int readDO_PWMConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public byte readDO_PWMConfig_PeriodPower() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0000) >>> 16;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readDO_PWMConfig_OutputSelect_0() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF000) >>> 12;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readDO_PWMConfig_OutputSelect_1() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF00) >>> 8;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readDO_PWMConfig_OutputSelect_2() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF0) >>> 4;
        return (byte)(bitfieldValue & 0xF);
    }

    public byte readDO_PWMConfig_OutputSelect_3() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kDO_PWMConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xF) >>> 0;
        return (byte)(bitfieldValue & 0xF);
    }

    public void writeI2CConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], value, status);
    }

    public void writeI2CConfig_Address(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0x807FFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 23 & 0x7F800000, status);
    }

    public void writeI2CConfig_BytesToRead(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFF8FFFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 20 & 0x700000, status);
    }

    public void writeI2CConfig_BytesToWrite(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFF1FFFF;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 17 & 0xE0000, status);
    }

    public void writeI2CConfig_DataToSendHigh(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFE0001;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= value << 1 & 0x1FFFE, status);
    }

    public void writeI2CConfig_BitwiseHandshake(boolean value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        regValue &= 0xFFFFFFFE;
        NiRioSrv.poke32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], regValue |= (value ? 1 : 0) << 0 & 1, status);
    }

    public int readI2CConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        return regValue;
    }

    public short readI2CConfig_Address() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x7F800000) >>> 23;
        return (short)(bitfieldValue & 0xFF);
    }

    public byte readI2CConfig_BytesToRead() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x700000) >>> 20;
        return (byte)(bitfieldValue & 7);
    }

    public byte readI2CConfig_BytesToWrite() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0xE0000) >>> 17;
        return (byte)(bitfieldValue & 7);
    }

    public int readI2CConfig_DataToSendHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 0x1FFFE) >>> 1;
        return bitfieldValue & 0xFFFF;
    }

    public boolean readI2CConfig_BitwiseHandshake() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, kI2CConfig_Addresses[this.m_SystemIndex], status);
        int bitfieldValue = (regValue & 1) >>> 0;
        return bitfieldValue != 0;
    }

    public static int readLoopTiming() {
        return NiRioSrv.peek32(m_DeviceHandle, 33640, status) & 0xFFFF;
    }

    public static void writePWMConfig(int value) {
        NiRioSrv.poke32(m_DeviceHandle, 33636, value, status);
    }

    public static void writePWMConfig_Period(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33636, status);
        regValue &= 0xFFFF;
        NiRioSrv.poke32(m_DeviceHandle, 33636, regValue |= value << 16 & 0xFFFF0000, status);
    }

    public static void writePWMConfig_MinHigh(int value) {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33636, status);
        regValue &= 0xFFFF0000;
        NiRioSrv.poke32(m_DeviceHandle, 33636, regValue |= value << 0 & 0xFFFF, status);
    }

    public static int readPWMConfig() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33636, status);
        return regValue;
    }

    public static int readPWMConfig_Period() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33636, status);
        int bitfieldValue = (regValue & 0xFFFF0000) >>> 16;
        return bitfieldValue & 0xFFFF;
    }

    public static int readPWMConfig_MinHigh() {
        int regValue = NiRioSrv.peek32(m_DeviceHandle, 33636, status);
        int bitfieldValue = (regValue & 0xFFFF) >>> 0;
        return bitfieldValue & 0xFFFF;
    }

    public void writePWMValue(int reg_index, int value) {
        if (status.isNotFatal() && reg_index >= 10) {
            status.setStatus(-50003);
        }
        NiRioSrv.poke32(m_DeviceHandle, kPWMValue_Addresses[this.m_SystemIndex * 10 + reg_index], value, status);
    }

    public short readPWMValue(int reg_index) {
        if (status.isNotFatal() && reg_index >= 10) {
            status.setStatus(-50003);
        }
        return (short)(NiRioSrv.peek32(m_DeviceHandle, kPWMValue_Addresses[this.m_SystemIndex * 10 + reg_index], status) & 0xFF);
    }
}

