/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.defaultCode;

import edu.wpi.first.wpilibj.AnalogChannel;
import edu.wpi.first.wpilibj.DigitalInput;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.Encoder;
import edu.wpi.first.wpilibj.IterativeRobot;
import edu.wpi.first.wpilibj.Jaguar;
import edu.wpi.first.wpilibj.Joystick;
import edu.wpi.first.wpilibj.Relay;
import edu.wpi.first.wpilibj.RobotDrive;
import edu.wpi.first.wpilibj.Solenoid;
import edu.wpi.first.wpilibj.Timer;
import edu.wpi.first.wpilibj.Watchdog;

public class DefaultRobot
extends IterativeRobot {
    RobotDrive m_robotDrive;
    DriverStation m_ds;
    int m_priorPacketNumber;
    int m_dsPacketsReceivedInCurrentSecond;
    Joystick m_rightStick;
    Joystick m_leftStick;
    static final int NUM_JOYSTICK_BUTTONS = 16;
    boolean[] m_rightStickButtonState = new boolean[17];
    boolean[] m_leftStickButtonState = new boolean[17];
    static final Relay m_conveyor = new Relay(1);
    static final Relay m_combine = new Relay(2);
    static final DigitalInput m_bottomDI = new DigitalInput(10);
    static final DigitalInput m_topDI = new DigitalInput(9);
    static final Jaguar m_leftshooter = new Jaguar(3);
    static final Jaguar m_rightshooter = new Jaguar(4);
    static final Timer m_timercombine = new Timer();
    static final Encoder m_encoder12 = new Encoder(1, 2);
    static final Encoder m_encoder34 = new Encoder(3, 4);
    static final Encoder m_encoder56 = new Encoder(5, 6);
    static final Encoder m_encoder78 = new Encoder(7, 8);
    static final AnalogChannel m_analogchannel = new AnalogChannel(5);
    static final int NUM_SOLENOIDS = 8;
    Solenoid[] m_solenoids = new Solenoid[8];
    static final int UNINITIALIZED_DRIVE = 0;
    static final int ARCADE_DRIVE = 1;
    static final int TANK_DRIVE = 2;
    int m_driveMode;
    int m_autoPeriodicLoops;
    int m_disabledPeriodicLoops;
    int m_telePeriodicLoops;
    int combineToggle = 0;
    int combineTogglePrev = 0;
    boolean ButtonTenValue;
    boolean ButtonTenValue_Old;
    int ShooterSpeedLock;
    double kScoreThreshold = 0.01;
    static int printSec = (int)((double)Timer.getUsClock() / 1000000.0 + 1.0);
    static final int startSec = (int)((double)Timer.getUsClock() / 1000000.0);

    public DefaultRobot() {
        System.out.println("BuiltinDefaultCode Constructor Started\n");
        this.m_robotDrive = new RobotDrive(2, 1);
        this.m_ds = DriverStation.getInstance();
        this.m_priorPacketNumber = 0;
        this.m_dsPacketsReceivedInCurrentSecond = 0;
        this.m_rightStick = new Joystick(1);
        this.m_leftStick = new Joystick(2);
        int buttonNum = 1;
        for (buttonNum = 1; buttonNum <= 16; ++buttonNum) {
            this.m_rightStickButtonState[buttonNum] = false;
            this.m_leftStickButtonState[buttonNum] = false;
        }
        int solenoidNum = 1;
        for (solenoidNum = 0; solenoidNum < 8; ++solenoidNum) {
            this.m_solenoids[solenoidNum] = new Solenoid(solenoidNum + 1);
        }
        this.m_driveMode = 0;
        this.m_autoPeriodicLoops = 0;
        this.m_disabledPeriodicLoops = 0;
        this.m_telePeriodicLoops = 0;
        System.out.println("BuiltinDefaultCode Constructor Completed\n");
    }

    public void robotInit() {
        Timer.delay(10.0);
        System.out.println("RobotInit() completed.\n");
        m_encoder12.reset();
        m_encoder12.start();
        m_encoder34.reset();
        m_encoder34.start();
        m_encoder56.reset();
        m_encoder56.start();
        m_encoder78.reset();
        m_encoder78.start();
    }

    public void disabledInit() {
        this.m_disabledPeriodicLoops = 0;
        this.ClearSolenoidLEDsKITT();
    }

    public void autonomousInit() {
        this.m_autoPeriodicLoops = 0;
        this.ClearSolenoidLEDsKITT();
    }

    public void teleopInit() {
        this.m_telePeriodicLoops = 0;
        this.m_dsPacketsReceivedInCurrentSecond = 0;
        this.m_driveMode = 0;
        this.ClearSolenoidLEDsKITT();
        m_timercombine.start();
        boolean lastTrigger = false;
        Timer.delay(1.0);
    }

    public void disabledPeriodic() {
        Watchdog.getInstance().feed();
        ++this.m_disabledPeriodicLoops;
    }

    public void autonomousPeriodic() {
        Watchdog.getInstance().feed();
        ++this.m_autoPeriodicLoops;
        if (this.m_autoPeriodicLoops % 100 == 0) {
            System.out.println("Number of autoloops: " + this.m_autoPeriodicLoops + "\r\n");
        }
        this.SolenoidLEDsKITT(this.m_autoPeriodicLoops);
        if (this.m_autoPeriodicLoops == 1) {
            this.m_robotDrive.drive(0.5, 0.0);
        }
        if (this.m_autoPeriodicLoops == 2 * this.GetLoopsPerSec()) {
            this.m_robotDrive.drive(0.0, 0.0);
        }
    }

    public void teleopPeriodic() {
        Watchdog.getInstance().feed();
        ++this.m_telePeriodicLoops;
        ++this.m_dsPacketsReceivedInCurrentSecond;
        Solenoid[] firstGroup = new Solenoid[4];
        Solenoid[] secondGroup = new Solenoid[4];
        for (int i = 0; i < 4; ++i) {
            firstGroup[i] = this.m_solenoids[i];
            secondGroup[i] = this.m_solenoids[i + 4];
        }
        this.DemonstrateJoystickButtons(this.m_rightStick, this.m_rightStickButtonState, "Right Stick", firstGroup);
        this.DemonstrateJoystickButtons(this.m_leftStick, this.m_leftStickButtonState, "Left Stick ", secondGroup);
        System.out.println("combineToggle = " + this.combineToggle);
        if (this.m_rightStick.getRawButton(3) && this.combineTogglePrev == 0) {
            if (this.combineToggle == 0) {
                this.combineToggle = 1;
            } else if (this.combineToggle == 1) {
                this.combineToggle = 0;
            }
            this.combineTogglePrev = 1;
        } else if (!this.m_rightStick.getRawButton(3) && this.combineTogglePrev == 1) {
            this.combineTogglePrev = 0;
        }
        if (this.m_rightStick.getRawButton(2)) {
            System.out.println("Button 3 Pressed");
            m_conveyor.set(Relay.Value.kReverse);
            m_combine.set(Relay.Value.kReverse);
        } else if (this.m_rightStick.getTrigger()) {
            System.out.println("Button Trigger Pressed");
            m_conveyor.set(Relay.Value.kForward);
            m_combine.set(Relay.Value.kForward);
        } else {
            if (this.combineToggle == 0) {
                m_combine.set(Relay.Value.kOff);
            } else if (this.combineToggle == 1) {
                m_combine.set(Relay.Value.kForward);
            }
            m_conveyor.set(Relay.Value.kOff);
        }
        if (this.m_rightStick.getThrottle() > 0.0) {
            if (this.m_rightStick.getThrottle() >= 0.75) {
                m_leftshooter.set(0.75);
                m_rightshooter.set(0.75);
            } else {
                m_leftshooter.set(this.m_rightStick.getThrottle());
                m_rightshooter.set(this.m_rightStick.getThrottle());
            }
        } else {
            m_leftshooter.set(0.0);
            m_rightshooter.set(0.0);
        }
        System.out.println("Throttle = " + this.m_rightStick.getThrottle());
        this.m_robotDrive.arcadeDrive(this.m_rightStick, false);
        if (this.m_driveMode != 1) {
            System.out.println("Arcade Drive\n");
            this.m_driveMode = 1;
        }
    }

    public double SetShooterSpeed(double ShooterJoystickY) {
        double ShooterSpeed = 0.0;
        double LockedShooterSpeed = ShooterJoystickY = Math.abs(ShooterJoystickY);
        this.ButtonTenValue = this.m_leftStick.getRawButton(10);
        if (this.ButtonTenValue && !this.ButtonTenValue_Old) {
            ShooterSpeed = LockedShooterSpeed;
            this.ShooterSpeedLock = 1 - this.ShooterSpeedLock;
            if (this.ShooterSpeedLock == 1) {
                System.out.println("Shooter Speed Locked");
            } else {
                System.out.println("Shooter Speed Unlocked");
            }
        }
        this.ButtonTenValue_Old = this.ButtonTenValue;
        if (this.ShooterSpeedLock == 1) {
            ShooterSpeed = LockedShooterSpeed;
        } else if (ShooterJoystickY == 0.0 && this.ShooterSpeedLock == 0) {
            ShooterSpeed = 0.25;
        } else if (this.ShooterSpeedLock == 0) {
            ShooterSpeed = ShooterJoystickY;
        }
        return ShooterSpeed;
    }

    public void ClearSolenoidLEDsKITT() {
        int solenoidNum = 1;
        for (solenoidNum = 0; solenoidNum < 8; ++solenoidNum) {
            this.m_solenoids[solenoidNum].set(false);
        }
    }

    public void SolenoidLEDsKITT(int numloops) {
        int NUM_KITT_POSITIONS = 6;
        int numloop_within_second = numloops % this.GetLoopsPerSec();
        if (numloop_within_second == 0) {
            this.m_solenoids[0].set(true);
            this.m_solenoids[7].set(true);
            this.m_solenoids[1].set(false);
            this.m_solenoids[6].set(false);
        } else if (numloop_within_second == this.GetLoopsPerSec() / 6) {
            this.m_solenoids[1].set(true);
            this.m_solenoids[6].set(true);
            this.m_solenoids[0].set(false);
            this.m_solenoids[7].set(false);
        } else if (numloop_within_second == this.GetLoopsPerSec() * 2 / 6) {
            this.m_solenoids[2].set(true);
            this.m_solenoids[5].set(true);
            this.m_solenoids[1].set(false);
            this.m_solenoids[6].set(false);
        } else if (numloop_within_second == this.GetLoopsPerSec() * 3 / 6) {
            this.m_solenoids[3].set(true);
            this.m_solenoids[4].set(true);
            this.m_solenoids[2].set(false);
            this.m_solenoids[5].set(false);
        } else if (numloop_within_second == this.GetLoopsPerSec() * 4 / 6) {
            this.m_solenoids[2].set(true);
            this.m_solenoids[5].set(true);
            this.m_solenoids[3].set(false);
            this.m_solenoids[4].set(false);
        } else if (numloop_within_second == this.GetLoopsPerSec() * 5 / 6) {
            this.m_solenoids[1].set(true);
            this.m_solenoids[6].set(true);
            this.m_solenoids[2].set(false);
            this.m_solenoids[5].set(false);
        }
    }

    int GetLoopsPerSec() {
        return 10000;
    }

    public void DemonstrateJoystickButtons(Joystick currStick, boolean[] buttonPreviouslyPressed, String stickString, Solenoid[] solenoids) {
        int buttonNum = 1;
        boolean outputGenerated = false;
        int numOfButtonPressed = 0;
        for (buttonNum = 1; buttonNum <= 16; ++buttonNum) {
            if (currStick.getRawButton(buttonNum)) {
                if (!buttonPreviouslyPressed[buttonNum]) {
                    if (!outputGenerated) {
                        outputGenerated = true;
                        System.out.println("%s button pressed:" + stickString);
                    }
                    System.out.println(" " + buttonNum);
                }
                buttonPreviouslyPressed[buttonNum] = true;
                if (numOfButtonPressed == 0) {
                    numOfButtonPressed = buttonNum;
                    continue;
                }
                numOfButtonPressed = -1;
                continue;
            }
            buttonPreviouslyPressed[buttonNum] = false;
        }
        if (outputGenerated) {
            System.out.println("\n");
        }
        if (numOfButtonPressed == -1) {
            this.DisplayBinaryNumberOnSolenoidLEDs(15, solenoids);
        } else {
            this.DisplayBinaryNumberOnSolenoidLEDs(numOfButtonPressed, solenoids);
        }
    }

    void DisplayBinaryNumberOnSolenoidLEDs(int displayNumber, Solenoid[] solenoids) {
        if (displayNumber > 15) {
            displayNumber = 0;
        }
        solenoids[3].set((displayNumber & 1) != 0);
        solenoids[2].set((displayNumber & 2) != 0);
        solenoids[1].set((displayNumber & 4) != 0);
        solenoids[0].set((displayNumber & 8) != 0);
    }
}

