/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj.can;

import edu.wpi.first.wpilibj.can.CANInvalidBufferException;
import edu.wpi.first.wpilibj.can.CANMessageNotAllowedException;
import edu.wpi.first.wpilibj.can.CANNotInitializedException;
import edu.wpi.first.wpilibj.can.CANTimeoutException;
import edu.wpi.first.wpilibj.util.UncleanStatusException;

public class CANExceptionFactory {
    static final int ERR_JaguarCANDriver_InvalidBuffer = -44086;
    static final int ERR_JaguarCANDriver_TimedOut = -44087;
    static final int ERR_JaguarCANDriver_NotAllowed = -44088;
    static final int ERR_JaguarCANDriver_NotInitialized = -44089;

    public static void checkStatus(int status, int messageID) throws CANInvalidBufferException, CANTimeoutException, CANMessageNotAllowedException, CANNotInitializedException, UncleanStatusException {
        switch (status) {
            case 0: {
                return;
            }
            case -63080: 
            case -44086: {
                throw new CANInvalidBufferException();
            }
            case -52007: 
            case -44087: {
                throw new CANTimeoutException();
            }
            case -63193: 
            case -44088: {
                throw new CANMessageNotAllowedException("MessageID = " + Integer.toString(messageID));
            }
            case -52010: 
            case -44089: {
                throw new CANNotInitializedException();
            }
        }
        throw new UncleanStatusException("Fatal status code detected:  " + Integer.toString(status));
    }
}

