/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tWatchdog;
import edu.wpi.first.wpilibj.parsing.IUtility;

public class Watchdog
extends SensorBase
implements IUtility {
    private static Watchdog m_instance;
    private tWatchdog m_fpgaWatchdog = new tWatchdog();
    public static final double kDefaultWatchdogExpiration = 0.5;

    protected Watchdog() {
        this.setExpiration(0.5);
        this.setEnabled(true);
    }

    public static synchronized Watchdog getInstance() {
        if (m_instance == null) {
            m_instance = new Watchdog();
        }
        return m_instance;
    }

    public void feed() {
        tWatchdog.strobeFeed();
    }

    public void kill() {
        tWatchdog.strobeKill();
    }

    public double getTimer() {
        long timer = tWatchdog.readTimer();
        return (double)timer / 4.0E7;
    }

    public double getExpiration() {
        long expiration = tWatchdog.readExpiration();
        return (double)expiration / 4.0E7;
    }

    public void setExpiration(double expiration) {
        tWatchdog.writeExpiration((int)(expiration * 4.0E7));
    }

    public boolean getEnabled() {
        return !tWatchdog.readImmortal();
    }

    public void setEnabled(boolean enabled) {
        tWatchdog.writeImmortal(!enabled);
    }

    public boolean isAlive() {
        return tWatchdog.readStatus_Alive();
    }

    public boolean isSystemActive() {
        return tWatchdog.readStatus_SystemActive();
    }
}

