/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.SolenoidBase;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class Solenoid
extends SolenoidBase {
    private int m_channel;

    private synchronized void initSolenoid() {
        Solenoid.checkSolenoidModule(this.m_chassisSlot);
        Solenoid.checkSolenoidChannel(this.m_channel);
        try {
            m_allocated.allocate(this.slotToIndex(this.m_chassisSlot) * 8 + this.m_channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Solenoid channel " + this.m_channel + " on module " + this.m_chassisSlot + " is already allocated");
        }
    }

    public Solenoid(int channel) {
        super(Solenoid.getDefaultSolenoidModule());
        this.m_channel = channel;
        this.initSolenoid();
    }

    public Solenoid(int slot, int channel) {
        super(slot);
        this.m_channel = channel;
        this.initSolenoid();
    }

    protected synchronized void free() {
        m_allocated.free(this.slotToIndex(this.m_chassisSlot) * 8 + this.m_channel - 1);
    }

    public void set(boolean on) {
        byte value = (byte)(on ? 255 : 0);
        byte mask = (byte)(1 << this.m_channel - 1);
        this.set(value, mask);
    }

    public boolean get() {
        int value = this.getAll() & 1 << this.m_channel - 1;
        return value != 0;
    }
}

