/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

public class SensorBase {
    private static final int[] modulePopulation = new int[]{0, 9201, 9201, 0, 9403, 0, 9403, 9472, 9472};
    public static final int kSystemClockTicksPerMicrosecond = 40;
    public static final int kDigitalChannels = 14;
    public static final int kAnalogChannels = 8;
    public static final int kAnalogModules = 2;
    public static final int kSolenoidChannels = 8;
    public static final int kSolenoidModules = 2;
    public static final int kPwmChannels = 10;
    public static final int kRelayChannels = 8;
    public static final int kChassisSlots = 8;
    private static int m_defaultAnalogModule = 1;
    private static int m_defaultDigitalModule = 4;
    private static int m_defaultSolenoidModule = 8;

    public static void setDefaultDigitalModule(int slot) {
        SensorBase.checkDigitalModule(slot);
        m_defaultDigitalModule = slot;
    }

    public static void setDefaultAnalogModule(int slot) {
        SensorBase.checkAnalogModule(slot);
        m_defaultAnalogModule = slot;
    }

    public static void setDefaultSolenoidModule(int slot) {
        SensorBase.checkSolenoidModule(slot);
        m_defaultSolenoidModule = slot;
    }

    protected static void checkDigitalModule(int slot) {
        if (slot > 8 || modulePopulation[slot] != 9403) {
            System.err.print("Module attached to slot ");
            System.err.print(slot);
            System.err.println(" is not a digital module.");
            throw new IndexOutOfBoundsException("Module attached to slot " + slot + " is not a digital module");
        }
    }

    protected static void checkRelayModule(int slot) {
        SensorBase.checkDigitalModule(slot);
    }

    protected static void checkPWMModule(int slot) {
        SensorBase.checkDigitalModule(slot);
    }

    protected static void checkAnalogModule(int slot) {
        if (slot > 8 || modulePopulation[slot] != 9201) {
            System.err.print("Module attached to slot ");
            System.err.print(slot);
            System.err.println(" is not an analog module.");
        }
    }

    protected static void checkSolenoidModule(int slot) {
        if (slot > 8 || modulePopulation[slot] != 9472) {
            System.err.print("Module attached to slot ");
            System.err.print(slot);
            System.err.println(" is not a solenoid module.");
        }
    }

    protected static void checkDigitalChannel(int channel) {
        if (channel <= 0 || channel > 14) {
            System.err.println("Requested digital channel number is out of range.");
        }
    }

    protected static void checkRelayChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested relay channel number is out of range.");
            throw new IndexOutOfBoundsException("Requested relay channel number is out of range.");
        }
    }

    protected static void checkPWMChannel(int channel) {
        if (channel <= 0 || channel > 10) {
            System.err.println("Requested PWM channel number is out of range.");
            throw new IndexOutOfBoundsException("Requested PWM channel number is out of range.");
        }
    }

    protected static void checkAnalogChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested analog channel number is out of range.");
        }
    }

    protected static void checkSolenoidChannel(int channel) {
        if (channel <= 0 || channel > 8) {
            System.err.println("Requested solenoid channel number is out of range.");
        }
    }

    public static int getDefaultAnalogModule() {
        return m_defaultAnalogModule;
    }

    public static int getDefaultDigitalModule() {
        return m_defaultDigitalModule;
    }

    public static int getDefaultSolenoidModule() {
        return m_defaultSolenoidModule;
    }

    protected void free() {
    }
}

