/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import com.sun.squawk.util.MathUtils;
import edu.wpi.first.wpilibj.DriverStation;
import edu.wpi.first.wpilibj.GenericHID;
import edu.wpi.first.wpilibj.parsing.IInputOutput;

public class Joystick
extends GenericHID
implements IInputOutput {
    static final byte kDefaultXAxis = 1;
    static final byte kDefaultYAxis = 2;
    static final byte kDefaultZAxis = 3;
    static final byte kDefaultTwistAxis = 3;
    static final byte kDefaultThrottleAxis = 4;
    static final int kDefaultTriggerButton = 1;
    static final int kDefaultTopButton = 2;
    private DriverStation m_ds = DriverStation.getInstance();
    private final int m_port;
    private final byte[] m_axes;
    private final byte[] m_buttons;

    public Joystick(int port) {
        this(port, AxisType.kNumAxis.value, ButtonType.kNumButton.value);
        this.m_axes[AxisType.kX.value] = 1;
        this.m_axes[AxisType.kY.value] = 2;
        this.m_axes[AxisType.kZ.value] = 3;
        this.m_axes[AxisType.kTwist.value] = 3;
        this.m_axes[AxisType.kThrottle.value] = 4;
        this.m_buttons[ButtonType.kTrigger.value] = 1;
        this.m_buttons[ButtonType.kTop.value] = 2;
    }

    protected Joystick(int port, int numAxisTypes, int numButtonTypes) {
        this.m_axes = new byte[numAxisTypes];
        this.m_buttons = new byte[numButtonTypes];
        this.m_port = port;
    }

    public double getX(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kX.value]);
    }

    public double getY(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kY.value]);
    }

    public double getZ(GenericHID.Hand hand) {
        return this.getRawAxis(this.m_axes[AxisType.kZ.value]);
    }

    public double getTwist() {
        return this.getRawAxis(this.m_axes[AxisType.kTwist.value]);
    }

    public double getThrottle() {
        return this.getRawAxis(this.m_axes[AxisType.kThrottle.value]);
    }

    public double getRawAxis(int axis) {
        return this.m_ds.getStickAxis(this.m_port, axis);
    }

    public double getAxis(AxisType axis) {
        switch (axis.value) {
            case 0: {
                return this.getX();
            }
            case 1: {
                return this.getY();
            }
            case 2: {
                return this.getZ();
            }
            case 3: {
                return this.getTwist();
            }
            case 4: {
                return this.getThrottle();
            }
        }
        return 0.0;
    }

    public boolean getTrigger(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTrigger.value]);
    }

    public boolean getTop(GenericHID.Hand hand) {
        return this.getRawButton(this.m_buttons[ButtonType.kTop.value]);
    }

    public boolean getBumper(GenericHID.Hand hand) {
        return false;
    }

    public boolean getRawButton(int button) {
        return (1 << button - 1 & this.m_ds.getStickButtons(this.m_port)) != 0;
    }

    public boolean getButton(ButtonType button) {
        switch (button.value) {
            case 0: {
                return this.getTrigger();
            }
            case 1: {
                return this.getTop();
            }
        }
        return false;
    }

    public double getMagnitude() {
        return Math.sqrt(MathUtils.pow((double)this.getX(), (double)2.0) + MathUtils.pow((double)this.getY(), (double)2.0));
    }

    public double getDirectionRadians() {
        return MathUtils.atan2((double)this.getX(), (double)(-this.getY()));
    }

    public double getDirectionDegrees() {
        return Math.toDegrees(this.getDirectionRadians());
    }

    public int getAxisChannel(AxisType axis) {
        return this.m_axes[axis.value];
    }

    public void setAxisChannel(AxisType axis, int channel) {
        this.m_axes[axis.value] = (byte)channel;
    }

    public static class ButtonType {
        public final int value;
        static final int kTrigger_val = 0;
        static final int kTop_val = 1;
        static final int kNumButton_val = 2;
        public static final ButtonType kTrigger = new ButtonType(0);
        public static final ButtonType kTop = new ButtonType(1);
        public static final ButtonType kNumButton = new ButtonType(2);

        private ButtonType(int value) {
            this.value = value;
        }
    }

    public static class AxisType {
        public final int value;
        static final int kX_val = 0;
        static final int kY_val = 1;
        static final int kZ_val = 2;
        static final int kTwist_val = 3;
        static final int kThrottle_val = 4;
        static final int kNumAxis_val = 5;
        public static final AxisType kX = new AxisType(0);
        public static final AxisType kY = new AxisType(1);
        public static final AxisType kZ = new AxisType(2);
        public static final AxisType kTwist = new AxisType(3);
        public static final AxisType kThrottle = new AxisType(4);
        public static final AxisType kNumAxis = new AxisType(5);

        private AxisType(int value) {
            this.value = value;
        }
    }
}

