/*
 * Decompiled with CFR 0.152.
 */
package edu.wpi.first.wpilibj;

import edu.wpi.first.wpilibj.AccumulatorResult;
import edu.wpi.first.wpilibj.AnalogModule;
import edu.wpi.first.wpilibj.PIDSource;
import edu.wpi.first.wpilibj.Resource;
import edu.wpi.first.wpilibj.SensorBase;
import edu.wpi.first.wpilibj.fpga.tAccumulator;
import edu.wpi.first.wpilibj.util.AllocationException;
import edu.wpi.first.wpilibj.util.CheckedAllocationException;

public class AnalogChannel
extends SensorBase
implements PIDSource {
    private static final int kAccumulatorSlot = 1;
    private static Resource channels = new Resource(16);
    private int m_channel;
    private int m_slot;
    private AnalogModule m_module;
    private static final int[] kAccumulatorChannels = new int[]{1, 2};
    private tAccumulator m_accumulator;
    private long m_accumulatorOffset;

    public AnalogChannel(int channel) {
        this(AnalogChannel.getDefaultAnalogModule(), channel);
    }

    public AnalogChannel(int slot, int channel) {
        AnalogChannel.checkAnalogModule(slot);
        AnalogChannel.checkAnalogChannel(slot);
        this.m_channel = channel;
        this.m_slot = slot;
        this.m_module = AnalogModule.getInstance(slot);
        try {
            channels.allocate(AnalogModule.slotToIndex(slot) * 2 + this.m_channel - 1);
        }
        catch (CheckedAllocationException e) {
            throw new AllocationException("Analog channel " + this.m_channel + " on module " + this.m_slot + " is already allocated");
        }
        if (channel == 1 || channel == 2) {
            this.m_accumulator = new tAccumulator((byte)(channel - 1));
            this.m_accumulatorOffset = 0L;
        } else {
            this.m_accumulator = null;
        }
    }

    protected void free() {
        channels.free(AnalogModule.slotToIndex(this.m_slot) * 2 + this.m_channel - 1);
        this.m_channel = 0;
        this.m_slot = 0;
        this.m_accumulator = null;
        this.m_accumulatorOffset = 0L;
    }

    public AnalogModule getModule() {
        return this.m_module;
    }

    public int getValue() {
        return this.m_module.getValue(this.m_channel);
    }

    public int getAverageValue() {
        return this.m_module.getAverageValue(this.m_channel);
    }

    public double getVoltage() {
        return this.m_module.getVoltage(this.m_channel);
    }

    public double getAverageVoltage() {
        return this.m_module.getAverageVoltage(this.m_channel);
    }

    public long getLSBWeight() {
        return this.m_module.getLSBWeight(this.m_channel);
    }

    public int getOffset() {
        return this.m_module.getOffset(this.m_channel);
    }

    public int getChannel() {
        return this.m_channel;
    }

    public int getSlot() {
        return this.m_module.getSlot();
    }

    public void setAverageBits(int bits) {
        this.m_module.setAverageBits(this.m_channel, bits);
    }

    public int getAverageBits() {
        return this.m_module.getAverageBits(this.m_channel);
    }

    public void setOversampleBits(int bits) {
        this.m_module.setOversampleBits(this.m_channel, bits);
    }

    public int getOversampleBits() {
        return this.m_module.getOversampleBits(this.m_channel);
    }

    public void initAccumulator() {
        if (!this.isAccumulatorChannel()) {
            throw new AllocationException("Accumulators are only available on slot 1 on channels " + kAccumulatorChannels[0] + "," + kAccumulatorChannels[1]);
        }
        this.m_accumulatorOffset = 0L;
        this.setAccumulatorCenter(0);
        this.resetAccumulator();
    }

    public void setAccumulatorInitialValue(long initialValue) {
        this.m_accumulatorOffset = initialValue;
    }

    public void resetAccumulator() {
        this.m_accumulator.strobeReset();
    }

    public void setAccumulatorCenter(int center) {
        this.m_accumulator.writeCenter(center);
    }

    public void setAccumulatorDeadband(int deadband) {
        this.m_accumulator.writeDeadband(deadband);
    }

    public long getAccumulatorValue() {
        long value = this.m_accumulator.readOutput_Value() + this.m_accumulatorOffset;
        return value;
    }

    public long getAccumulatorCount() {
        long count = this.m_accumulator.readOutput_Count();
        return count;
    }

    public void getAccumulatorOutput(AccumulatorResult result) {
        if (result == null) {
            System.out.println("Null result in getAccumulatorOutput");
        }
        if (this.m_accumulator == null) {
            System.out.println("Null m_accumulator in getAccumulatorOutput");
        }
        result.value = this.m_accumulator.readOutput_Value() + this.m_accumulatorOffset;
        result.count = this.m_accumulator.readOutput_Count();
    }

    public boolean isAccumulatorChannel() {
        if (this.m_module.getSlot() != 1) {
            return false;
        }
        for (int i = 0; i < kAccumulatorChannels.length; ++i) {
            if (this.m_channel != kAccumulatorChannels[i]) continue;
            return true;
        }
        return false;
    }

    public double pidGet() {
        return this.getAverageValue();
    }
}

